/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary;

import fit.exception.FitFailureExceptionWithHelp;
import fit.exception.VoidMethodFitFailureException;
import fitlibrary.ExtendedCamelCase;
import fitlibrary.FunctionFixture;
import fitlibrary.closure.MethodTarget;
import fitlibrary.parse.Cell;
import fitlibrary.parse.Row;
import java.util.ArrayList;

public class CalculateFixture
extends FunctionFixture {
    private MethodTarget[] targets;
    private int methods = 0;
    private boolean notesPermitted = false;
    private boolean hasNotes = false;
    protected int argCount = -1;
    protected boolean boundOK = false;

    public CalculateFixture() {
    }

    public CalculateFixture(Object sut) {
        super(sut);
    }

    protected void processRow(Row row) {
        if (!this.boundOK) {
            row.ignore(this.counts);
            return;
        }
        if (this.hasNotes) {
            if (row.size() < this.argCount + this.methods + 1) {
                row.exception(this, (Throwable)((Object)new FitFailureExceptionWithHelp("Row should be at least " + (this.argCount + this.methods + 1) + " cells wide", "CalculateRowTooShort")));
                return;
            }
        } else if (row.size() != this.argCount + this.methods + 1) {
            row.exception(this, (Throwable)((Object)new FitFailureExceptionWithHelp("Row should be " + (this.argCount + this.methods + 1) + " cells wide", "CalculateRowWrongLength")));
            return;
        }
        int i = 0;
        while (i < this.methods) {
            this.targets[i].invokeAndCheck(row, row.cell((int)(i + this.argCount + 1)).parse);
            ++i;
        }
    }

    protected void bindFirstRowToTarget(Row row) {
        boolean pastDoubleColumn = false;
        int rowLength = row.size();
        String argNames = "";
        ArrayList<String> arguments = new ArrayList<String>();
        int i = 0;
        while (i < rowLength) {
            Cell cell = row.cell(i);
            String name = cell.text();
            try {
                if (name.equals("")) {
                    if (pastDoubleColumn && this.notesPermitted) {
                        this.hasNotes = true;
                        break;
                    }
                    this.argCount = i;
                    arguments.add("arg" + (i + 1));
                    this.targets = new MethodTarget[rowLength - i - 1];
                    pastDoubleColumn = true;
                } else {
                    this.notesPermitted = true;
                    if (pastDoubleColumn) {
                        MethodTarget target;
                        String methodName = ExtendedCamelCase.camel(name + argNames);
                        if (arguments.size() > this.argCount) {
                            arguments.remove(arguments.size() - 1);
                        }
                        if ((target = this.findMethod(methodName, arguments)).getReturnType() == Void.TYPE) {
                            throw new VoidMethodFitFailureException(methodName, "CalculateFixture");
                        }
                        this.targets[this.methods] = target;
                        ++this.methods;
                        target.setRepeatAndExceptionString(this.repeatString, this.exceptionString);
                    } else {
                        arguments.add(ExtendedCamelCase.camel(name));
                        argNames = argNames + " " + name;
                    }
                }
            }
            catch (Exception e) {
                cell.exception(this, e);
                return;
            }
            ++i;
        }
        if (this.methods == 0) {
            row.exception(this, (Throwable)((Object)new FitFailureExceptionWithHelp("No calculated column", "NoCalculateColumn")));
        }
        this.boundOK = true;
    }
}

