/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.WidgetWithTextArgument;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XRefWidget
extends ParentWidget
implements WidgetWithTextArgument {
    public static final String REGEXP = "^!see (?:\\^|\\./|(?:\\.\\./)+)?(?:[./]?\\b[A-Z](?:[a-z0-9]+[A-Z][a-z0-9]*)+)+\\b";
    private static final Pattern pattern = Pattern.compile("^!see (.*)");
    private String pageName;

    public XRefWidget(ParentWidget parentWidget, String string) throws Exception {
        super(parentWidget);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.pageName = matcher.group(1);
            this.addChildWidgets(this.pageName);
        }
    }

    public String render() throws Exception {
        return HtmlUtil.metaText("<b>See: " + this.childHtml() + "</b>");
    }

    public String asWikiText() throws Exception {
        return "!see " + this.pageName;
    }

    public String getText() {
        return this.pageName;
    }
}

