/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.components.PageReferencer;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.WidgetVisitor;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.TextWidget;
import java.util.regex.Pattern;

public class WikiWordWidget
extends TextWidget
implements PageReferencer {
    public static final String SINGLE_WIKIWORD_REGEXP = "\\b[A-Z](?:[a-z0-9]+[A-Z][a-z0-9]*)+";
    public static final String REGEXP = "(?:\\^|\\./|(?:\\.\\./)+)?(?:[./]?\\b[A-Z](?:[a-z0-9]+[A-Z][a-z0-9]*)+)+\\b";
    public WikiPage parentPage;

    public WikiWordWidget(ParentWidget parentWidget, String string) throws Exception {
        super(parentWidget, string);
        WikiPage wikiPage = this.getWikiPage();
        this.parentPage = wikiPage.getParent();
    }

    public String render() throws Exception {
        WikiPagePath wikiPagePath = PathParser.parse(this.getWikiWord());
        WikiPagePath wikiPagePath2 = this.parentPage.getPageCrawler().getFullPathOfChild(this.parentPage, wikiPagePath);
        String string = PathParser.render(wikiPagePath2);
        if (this.parentPage.getPageCrawler().pageExists(this.parentPage, PathParser.parse(this.getWikiWord()))) {
            return this.makeLinkToExistingWikiPage(string);
        }
        return this.makeLinkToNonExistentWikiPage(string);
    }

    private String makeLinkToNonExistentWikiPage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getText());
        stringBuffer.append("<a href=\"").append(string);
        stringBuffer.append("?edit");
        stringBuffer.append("\">?</a>");
        return stringBuffer.toString();
    }

    private String makeLinkToExistingWikiPage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<a href=\"");
        stringBuffer.append(string).append("\">");
        stringBuffer.append(this.getText()).append("</a>");
        return stringBuffer.toString();
    }

    public void renamePageIfReferenced(WikiPage wikiPage, String string) throws Exception {
        String string2 = this.getQualifiedWikiWord();
        WikiPagePath wikiPagePath = wikiPage.getPageCrawler().getFullPath(wikiPage);
        wikiPagePath.makeAbsolute();
        String string3 = PathParser.render(wikiPagePath);
        if (WikiWordWidget.refersTo(string2, string3)) {
            int n = string3.length();
            String string4 = "." + this.rename(string3.substring(1), string);
            String string5 = string4 + string2.substring(n);
            String string6 = this.makeRenamedRelativeReference(string5);
            this.setText(string6);
        }
    }

    public void renameMovedPageIfReferenced(WikiPage wikiPage, String string) throws Exception {
        WikiPagePath wikiPagePath = wikiPage.getPageCrawler().getFullPath(wikiPage);
        wikiPagePath.makeAbsolute();
        String string2 = PathParser.render(wikiPagePath);
        String string3 = this.getQualifiedWikiWord();
        if (WikiWordWidget.refersTo(string3, string2)) {
            String string4 = string3.substring(string2.length());
            String string5 = wikiPage.getName();
            if (string4.length() > 0) {
                string5 = string5 + string4;
            }
            String string6 = "".equals(string) ? "." + string5 : "." + string + "." + string5;
            this.setText(string6);
        }
    }

    public String makeRenamedRelativeReference(String string) throws Exception {
        String string2;
        String string3 = string2 = this.getText();
        try {
            if (string2.startsWith(".")) {
                string3 = string;
            } else {
                WikiPagePath wikiPagePath = this.parentPage.getPageCrawler().getFullPath(this.parentPage);
                wikiPagePath.makeAbsolute();
                String string4 = PathParser.render(wikiPagePath);
                boolean bl = !this.parentPage.getPageCrawler().isRoot(this.parentPage);
                String string5 = string4 + (bl ? "." : "");
                String string6 = string.substring(string5.length());
                if (string.startsWith(string5)) {
                    string3 = string2.startsWith("^") ? "^" + string6.substring(string6.indexOf(".") + 1) : string6;
                }
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return string;
        }
        return string3;
    }

    static boolean refersTo(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        return string.startsWith(string2 + ".");
    }

    private String getQualifiedWikiWord() throws Exception {
        String string = this.expandUparrow(this.getText());
        WikiPagePath wikiPagePath = PathParser.parse(string);
        if (wikiPagePath == null) {
            return this.getText();
        }
        WikiPagePath wikiPagePath2 = this.parentPage.getPageCrawler().getFullPathOfChild(this.parentPage, wikiPagePath);
        return "." + PathParser.render(wikiPagePath2);
    }

    private String rename(String string, String string2) {
        String string3 = string;
        int n = string.lastIndexOf(".");
        string3 = n < 1 ? string2 : string.substring(0, n + 1) + string2;
        return string3;
    }

    String getWikiWord() throws Exception {
        String string = this.getText();
        string = this.expandUparrow(string);
        return string;
    }

    public static boolean isWikiWord(String string) {
        return Pattern.matches(REGEXP, string);
    }

    protected String expandUparrow(String string) throws Exception {
        if (string.charAt(0) == '^') {
            string = this.getWikiPage().getName() + "." + string.substring(1);
        }
        return string;
    }

    public WikiPage getReferencedPage() throws Exception {
        String string = this.getWikiWord();
        return this.parentPage.getPageCrawler().getPage(this.parentPage, PathParser.parse(string));
    }

    public void acceptVisitor(WidgetVisitor widgetVisitor) throws Exception {
        widgetVisitor.visit(this);
    }

    public static boolean isSingleWikiWord(String string) {
        return Pattern.matches(SINGLE_WIKIWORD_REGEXP, string);
    }
}

