/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wiki.PagePointer;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WidgetRoot
extends ParentWidget {
    private Map variables = new HashMap();
    private WidgetBuilder builder;
    private WikiPage page;
    private PagePointer pagePointer;
    private boolean doEscaping = true;
    private List literals = new LinkedList();

    public WidgetRoot(WikiPage wikiPage) throws Exception {
        this("", wikiPage, WidgetBuilder.htmlWidgetBuilder);
    }

    public WidgetRoot(String string, WikiPage wikiPage) throws Exception {
        this(string, wikiPage, WidgetBuilder.htmlWidgetBuilder);
    }

    public WidgetRoot(String string, WikiPage wikiPage, WidgetBuilder widgetBuilder) throws Exception {
        super(null);
        this.page = wikiPage;
        this.builder = widgetBuilder;
        if (string != null) {
            this.buildWidgets(string);
        }
    }

    public WidgetRoot(PagePointer pagePointer) throws Exception {
        this("", pagePointer, WidgetBuilder.htmlWidgetBuilder);
    }

    public WidgetRoot(String string, PagePointer pagePointer) throws Exception {
        this(string, pagePointer, WidgetBuilder.htmlWidgetBuilder);
    }

    public WidgetRoot(String string, PagePointer pagePointer, WidgetBuilder widgetBuilder) throws Exception {
        super(null);
        this.page = pagePointer.getPage();
        this.builder = widgetBuilder;
        if (string != null) {
            this.buildWidgets(string);
        }
    }

    public WidgetBuilder getBuilder() {
        return this.builder;
    }

    protected void buildWidgets(String string) throws Exception {
        String string2 = this.processLiterals(string);
        this.addChildWidgets(string2);
    }

    public String render() throws Exception {
        return this.childHtml();
    }

    public String getVariable(String string) throws Exception {
        String string2 = (String)this.variables.get(string);
        WikiPage wikiPage = this.getWikiPage();
        while (string2 == null && !wikiPage.getPageCrawler().isRoot(wikiPage)) {
            wikiPage = wikiPage.getParent();
            string2 = wikiPage.getData().getVariable(string);
        }
        if (string2 == null) {
            string2 = System.getProperty(string);
        }
        return string2;
    }

    public void addVariable(String string, String string2) {
        this.variables.put(string, string2);
    }

    public int defineLiteral(String string) {
        int n = this.literals.size();
        this.literals.add(string);
        return n;
    }

    public String getLiteral(int n) {
        if (n >= this.literals.size()) {
            return "literal(" + n + ") not found.";
        }
        return (String)this.literals.get(n);
    }

    public WikiPage getWikiPage() {
        return this.page;
    }

    public void setEscaping(boolean bl) {
        this.doEscaping = bl;
    }

    public boolean doEscaping() {
        return this.doEscaping;
    }

    public List getLiterals() {
        return this.literals;
    }

    public void setLiterals(List list) {
        this.literals = list;
    }

    public String asWikiText() throws Exception {
        return this.childWikiText();
    }
}

