/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableWidget
extends ParentWidget {
    public static final String REGEXP = "\\$\\{\\w+\\}";
    public static final Pattern pattern = Pattern.compile("\\$\\{(\\w+)\\}", 40);
    private String name = null;
    private String renderedText;
    private boolean rendered;

    public VariableWidget(ParentWidget parentWidget, String string) {
        super(parentWidget);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.name = matcher.group(1);
        }
    }

    public String render() throws Exception {
        if (!this.rendered) {
            this.doRender();
        }
        return this.renderedText;
    }

    private void doRender() throws Exception {
        String string = this.parent.getVariable(this.name);
        if (string != null) {
            this.addChildWidgets(string);
            this.renderedText = this.childHtml();
        } else {
            this.renderedText = this.makeUndefinedVariableExpression(this.name);
        }
        this.rendered = true;
    }

    private String makeUndefinedVariableExpression(String string) throws Exception {
        return HtmlUtil.metaText("undefined variable: " + string);
    }

    public String asWikiText() throws Exception {
        return "${" + this.name + "}";
    }
}

