/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableDefinitionWidget
extends ParentWidget {
    public static final String REGEXP = "^!define \\w+ (?:(?:\\{[^}]*\\})|(?:\\([^)]*\\)))";
    private static final Pattern pattern = Pattern.compile("^!define (\\w+) ([\\{\\(])(.*)[\\}\\)]", 40);
    public String name;
    public String value;

    public VariableDefinitionWidget(ParentWidget parentWidget, String string) throws Exception {
        super(parentWidget);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.name = matcher.group(1);
            this.value = matcher.group(3);
        }
    }

    public String render() throws Exception {
        this.parent.addVariable(this.name, this.value);
        return HtmlUtil.metaText("variable defined: " + this.name + "=" + this.value);
    }

    public String asWikiText() throws Exception {
        String string = "!define " + this.name + " ";
        string = this.value.indexOf("{") == -1 ? string + "{" + this.value + "}" : string + "(" + this.value + ")";
        return string;
    }
}

