/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.TableRowWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableWidget
extends ParentWidget {
    public static final String LF = "(?:(?:\r\n)|\n|\r)";
    public static final String REGEXP = "^!?(?:\\|[^\r\n]*?\\|(?:(?:\r\n)|\n|\r))+";
    private static final Pattern pattern = Pattern.compile("(!?)(\\|[^\r\n]*?)\\|(?:(?:\r\n)|\n|\r)");
    public boolean isTestTable;
    private int columns = 0;

    public int getColumns() {
        return this.columns;
    }

    public TableWidget(ParentWidget parentWidget, String string) throws Exception {
        super(parentWidget);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.isTestTable = "!".equals(matcher.group(1));
            this.addRows(string);
            this.getMaxNumberOfColumns();
        }
    }

    private void getMaxNumberOfColumns() {
        for (TableRowWidget tableRowWidget : this.children) {
            this.columns = Math.max(this.columns, tableRowWidget.getColumns());
        }
    }

    public String render() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("<table border=\"1\" cellspacing=\"0\">\n");
        stringBuffer.append(this.childHtml()).append("</table>\n");
        return stringBuffer.toString();
    }

    private void addRows(String string) throws Exception {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            new TableRowWidget(this, matcher.group(2), this.isTestTable);
            this.addRows(string.substring(matcher.end()));
        }
    }
}

