/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.TableCellWidget;
import fitnesse.wikitext.widgets.TableWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableRowWidget
extends ParentWidget {
    private static final Pattern pattern = Pattern.compile("\\|([^\\|\n\r]*)");
    private TableWidget parentTable;
    private boolean isLiteral;

    public TableRowWidget(TableWidget tableWidget, String string, boolean bl) throws Exception {
        super(tableWidget);
        this.parentTable = tableWidget;
        this.isLiteral = bl;
        this.addCells(string);
    }

    public int getColumns() {
        return this.numberOfChildren();
    }

    public TableWidget getParentTable() {
        return this.parentTable;
    }

    public String render() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("<tr>");
        stringBuffer.append(this.childHtml()).append("</tr>\n");
        return stringBuffer.toString();
    }

    private void addCells(String string) throws Exception {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            new TableCellWidget(this, matcher.group(1), this.isLiteral);
            this.addCells(string.substring(matcher.end()));
        }
    }
}

