/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlTag;
import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.TableRowWidget;
import java.util.regex.Pattern;

public class TableCellWidget
extends ParentWidget {
    private static Pattern NEWLINE_PATTERN = Pattern.compile("\\\\((?:(?:\r\n)|\n|\r))");
    private TableRowWidget parentRow = null;
    private boolean isLiteral;

    public TableCellWidget(TableRowWidget tableRowWidget, String string, boolean bl) throws Exception {
        super(tableRowWidget);
        this.parentRow = tableRowWidget;
        this.isLiteral = bl;
        this.addChildWidgets(this.groomText(string));
    }

    private String groomText(String string) {
        string = string.replaceAll("\\\\\\r", "\r").replaceAll("\\\\\\n", "\n");
        return string.trim();
    }

    public String render() throws Exception {
        return this.makeCellTag();
    }

    private String makeCellTag() throws Exception {
        HtmlTag htmlTag = new HtmlTag("td");
        if (this.computeColSpan().length() > 0) {
            htmlTag.addAttribute("colspan", this.computeColSpan());
        }
        if (this.childHtml().equals("")) {
            htmlTag.add("&nbsp;");
        } else {
            htmlTag.add(this.childHtml());
        }
        return htmlTag.html();
    }

    private String computeColSpan() {
        int n = this.parentRow.children.indexOf(this) + 1;
        int n2 = this.parentRow.getParentTable().getColumns();
        int n3 = this.parentRow.numberOfChildren();
        String string = "";
        if (n == n3 && n != n2) {
            string = String.valueOf(n2 - n + 1);
        }
        return string;
    }

    public WidgetBuilder getBuilder() {
        if (this.isLiteral) {
            return WidgetBuilder.literalAndVariableWidgetBuilder;
        }
        return this.parent.getBuilder();
    }
}

