/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.VirtualCouplingExtension;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TOCWidget
extends WikiWidget {
    public static final String REGEXP = "(?:^!contents[ \t]*$)|(?:^!contents -R[ \t]*$)";
    private boolean recursive;

    public TOCWidget(ParentWidget parentWidget, String string) {
        super(parentWidget);
        this.setRecursive(string);
    }

    private void setRecursive(String string) {
        this.recursive = string.indexOf("-R") > -1;
    }

    public String render() throws Exception {
        return this.buildContentsDiv(this.getWikiPage(), 1).html();
    }

    private HtmlTag buildContentsDiv(WikiPage wikiPage, int n) throws Exception {
        HtmlTag htmlTag = this.makeDivTag(n);
        htmlTag.add(this.buildList(wikiPage, n));
        return htmlTag;
    }

    private HtmlTag buildList(WikiPage wikiPage, int n) throws Exception {
        HtmlTag htmlTag = new HtmlTag("ul");
        Iterator iterator = this.buildListOfChildPages(wikiPage).iterator();
        while (iterator.hasNext()) {
            htmlTag.add(this.buildListItem((WikiPage)iterator.next(), n));
        }
        return htmlTag;
    }

    private HtmlTag buildListItem(WikiPage wikiPage, int n) throws Exception {
        HtmlTag htmlTag = new HtmlTag("li");
        htmlTag.add(HtmlUtil.makeLink(this.getHref(wikiPage), this.getLinkText(wikiPage)));
        if (this.isRecursive() && this.buildListOfChildPages(wikiPage).size() > 0) {
            htmlTag.add(this.buildContentsDiv(wikiPage, n + 1));
        }
        return htmlTag;
    }

    private String getHref(WikiPage wikiPage) throws Exception {
        String string = null;
        WikiPagePath wikiPagePath = wikiPage.getPageCrawler().getFullPath(wikiPage);
        string = PathParser.render(wikiPagePath);
        return string;
    }

    private HtmlElement getLinkText(WikiPage wikiPage) throws Exception {
        if (wikiPage instanceof ProxyPage) {
            return new HtmlTag("i", wikiPage.getName());
        }
        return new RawHtml(wikiPage.getName());
    }

    private List buildListOfChildPages(WikiPage wikiPage) throws Exception {
        ArrayList<WikiPage> arrayList = new ArrayList<WikiPage>(wikiPage.getChildren());
        if (wikiPage.hasExtension("VirtualCoupling")) {
            VirtualCouplingExtension virtualCouplingExtension = (VirtualCouplingExtension)wikiPage.getExtension("VirtualCoupling");
            WikiPage wikiPage2 = virtualCouplingExtension.getVirtualCoupling();
            arrayList.addAll(wikiPage2.getChildren());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private HtmlTag makeDivTag(int n) {
        return HtmlUtil.makeDivTag("toc" + n);
    }

    public boolean isRecursive() {
        return this.recursive;
    }
}

