/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PreformattedWidget
extends ParentWidget {
    public static final String REGEXP = "\\{\\{\\{.+?\\}\\}\\}";
    private static final Pattern pattern = Pattern.compile("\\{{3}(.+?)\\}{3}", 32);

    public PreformattedWidget(ParentWidget parentWidget, String string) throws Exception {
        super(parentWidget);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.addChildWidgets(matcher.group(1));
        }
    }

    public String render() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("<pre>");
        stringBuffer.append(this.childHtml()).append("</pre>");
        return stringBuffer.toString();
    }

    public String asWikiText() throws Exception {
        return "{{{" + this.childWikiText() + "}}}";
    }

    public WidgetBuilder getBuilder() {
        return WidgetBuilder.literalAndVariableWidgetBuilder;
    }
}

