/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.WidgetVisitor;
import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.PreProcessorLiteralWidget;
import fitnesse.wikitext.widgets.TextWidget;
import java.util.LinkedList;
import java.util.List;

public abstract class ParentWidget
extends WikiWidget {
    protected LinkedList children = new LinkedList();
    private int currentChild = 0;
    public static WidgetBuilder preprocessingLiteralWidgetBuilder = new WidgetBuilder(new Class[]{PreProcessorLiteralWidget.class});

    public ParentWidget(ParentWidget parentWidget) {
        super(parentWidget);
    }

    public void reset() {
        this.children.clear();
        this.currentChild = 0;
    }

    public void addChild(WikiWidget wikiWidget) {
        this.children.add(wikiWidget);
    }

    public int numberOfChildren() {
        return this.children.size();
    }

    public List getChildren() {
        return this.children;
    }

    public WikiWidget nextChild() {
        if (this.hasNextChild()) {
            return (WikiWidget)this.children.get(this.currentChild++);
        }
        throw new ArrayIndexOutOfBoundsException("No next child exists");
    }

    public boolean hasNextChild() {
        return this.currentChild < this.numberOfChildren();
    }

    public String childHtml() throws Exception {
        this.currentChild = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (this.hasNextChild()) {
            WikiWidget wikiWidget = this.nextChild();
            stringBuffer.append(wikiWidget.render());
        }
        return stringBuffer.toString();
    }

    public String childWikiText() throws Exception {
        this.currentChild = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (this.hasNextChild()) {
            WikiWidget wikiWidget = this.nextChild();
            stringBuffer.append(wikiWidget.asWikiText());
        }
        return stringBuffer.toString();
    }

    public int defineLiteral(String string) {
        return this.parent.defineLiteral(string);
    }

    public String getLiteral(int n) {
        return this.parent.getLiteral(n);
    }

    public void addVariable(String string, String string2) {
        this.parent.addVariable(string, string2);
    }

    public String getVariable(String string) throws Exception {
        return this.parent.getVariable(string);
    }

    public void addChildWidgets(String string) throws Exception {
        this.getBuilder().addChildWidgets(string, this);
    }

    public WidgetBuilder getBuilder() {
        return this.parent.getBuilder();
    }

    public boolean doEscaping() {
        return this.parent.doEscaping();
    }

    public boolean preProcessingComplete() {
        return this.children.size() == 1 && this.children.get(0) instanceof TextWidget;
    }

    public void acceptVisitor(WidgetVisitor widgetVisitor) throws Exception {
        widgetVisitor.visit(this);
        this.currentChild = 0;
        while (this.hasNextChild()) {
            WikiWidget wikiWidget = this.nextChild();
            wikiWidget.acceptVisitor(widgetVisitor);
        }
    }

    public String processLiterals(String string) throws Exception {
        return new LiteralProcessingWidgetRoot(this, string).childHtml();
    }

    public static class LiteralProcessingWidgetRoot
    extends ParentWidget {
        public LiteralProcessingWidgetRoot(ParentWidget parentWidget, String string) throws Exception {
            super(parentWidget);
            if (string != null) {
                this.addChildWidgets(string);
            }
        }

        public WidgetBuilder getBuilder() {
            return preprocessingLiteralWidgetBuilder;
        }

        public boolean doEscaping() {
            return false;
        }

        public String render() throws Exception {
            return "";
        }

        protected void addToParent() {
        }
    }
}

