/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaWidget
extends ParentWidget {
    public static final String REGEXP = "^!meta [^\r\n]*";
    private static final Pattern pattern = Pattern.compile("^!meta (.*)");
    private String content;

    public MetaWidget(ParentWidget parentWidget, String string) throws Exception {
        super(parentWidget);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.setContent(matcher.group(1));
        }
    }

    private void setContent(String string) throws Exception {
        this.content = string;
        this.addChildWidgets(this.content);
    }

    public String render() throws Exception {
        return HtmlUtil.metaText(this.childHtml());
    }

    public String asWikiText() throws Exception {
        return "!meta " + this.content;
    }
}

