/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.widgets.ListItemWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ListWidget
extends ParentWidget {
    public static final String REGEXP = "(?:^[ \\t]+[\\*\\d][^\r\n]*(?:(?:\r\n)|\n|\r)?)+";
    private static final Pattern pattern = Pattern.compile("([ \\t]+)([\\*\\d])([^\r\n]*)");
    private boolean ordered = false;
    private int level;

    public ListWidget(ParentWidget parentWidget, String string) throws Exception {
        super(parentWidget);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.level = this.findLevel(matcher);
            this.ordered = !"*".equals(matcher.group(2));
        }
        this.buildList(string);
    }

    private ListWidget(ParentWidget parentWidget, Matcher matcher) {
        super(parentWidget);
        this.level = this.findLevel(matcher);
        this.ordered = !"*".equals(matcher.group(2));
    }

    private String buildList(String string) throws Exception {
        if (string == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            int n = this.findLevel(matcher);
            if (n > this.level) {
                ListWidget listWidget = new ListWidget((ParentWidget)this, matcher);
                String string2 = listWidget.buildList(string);
                return this.buildList(string2);
            }
            if (n < this.level) {
                return string;
            }
            String string3 = matcher.group(3).trim();
            new ListItemWidget(this, string3, this.level + 1);
            return this.buildList(string.substring(matcher.end()));
        }
        return null;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public int getLevel() {
        return this.level;
    }

    public String render() throws Exception {
        String string = this.ordered ? "ol" : "ul";
        StringBuffer stringBuffer = new StringBuffer();
        this.appendTabs(stringBuffer);
        stringBuffer.append("<").append(string).append(">").append("\n");
        stringBuffer.append(this.childHtml());
        this.appendTabs(stringBuffer);
        stringBuffer.append("</").append(string).append(">").append("\n");
        return stringBuffer.toString();
    }

    private void appendTabs(StringBuffer stringBuffer) {
        for (int i = 0; i < this.level; ++i) {
            stringBuffer.append("\t");
        }
    }

    private int findLevel(Matcher matcher) {
        return matcher.group(1).length() - 1;
    }
}

