/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkWidget
extends ParentWidget {
    public static final String REGEXP = "https?://[^\\s]+[^\\s.)]+";
    private static final Pattern pattern = Pattern.compile("https?://([^/\\s]*)(\\S*)?");

    public LinkWidget(ParentWidget parentWidget, String string) throws Exception {
        super(parentWidget);
        this.addChildWidgets(string);
    }

    public String render() throws Exception {
        String string = this.childHtml();
        String string2 = LinkWidget.makeUrlUsable(string);
        StringBuffer stringBuffer = new StringBuffer("<a href=\"");
        stringBuffer.append(string2);
        stringBuffer.append("\">");
        stringBuffer.append(string);
        stringBuffer.append("</a>");
        return stringBuffer.toString();
    }

    public static String makeUrlUsable(String string) {
        String string2 = string;
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            if ("files".equals(string3)) {
                string2 = "/files" + string4;
            }
        }
        return string2;
    }

    public WidgetBuilder getBuilder() {
        return WidgetBuilder.variableWidgetBuilder;
    }

    public String asWikiText() throws Exception {
        return this.childWikiText();
    }
}

