/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.components.PageReferencer;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.VirtualEnabledPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.widgets.CollapsableWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IncludeWidget
extends ParentWidget
implements PageReferencer {
    public static final String REGEXP = "^!include(?: +-setup| +-teardown| +-seamless| +-c)? (?:\\^|\\./|(?:\\.\\./)+)?(?:[./]?\\b[A-Z](?:[a-z0-9]+[A-Z][a-z0-9]*)+)+\\b(?:(?:\r\n)|\n|\r)?";
    static final Pattern pattern = Pattern.compile("^!include *(-setup|-teardown|-seamless|-c)? (.*)");
    public static final String COLLAPSE_SETUP = "COLLAPSE_SETUP";
    public static final String COLLAPSE_TEARDOWN = "COLLAPSE_TEARDOWN";
    protected String pageName;
    protected WikiPage includingPage;
    protected WikiPage parentPage;
    private static Map optionPrefixMap = IncludeWidget.buildOptionPrefixMap();
    private static Map optionCssMap = IncludeWidget.buildOptionsCssMap();

    public IncludeWidget(ParentWidget parentWidget, String string) throws Exception {
        super(parentWidget);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.pageName = this.getPageName(matcher);
            this.includingPage = parentWidget.getWikiPage();
            this.parentPage = this.includingPage.getParent();
            this.buildWidget(this.getOption(matcher));
        }
    }

    protected String getIncludedPageContent() throws Exception {
        PageCrawler pageCrawler = this.parentPage.getPageCrawler();
        pageCrawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
        WikiPagePath wikiPagePath = PathParser.parse(this.pageName);
        if (pageCrawler.pageExists(this.parentPage, wikiPagePath)) {
            WikiPage wikiPage = this.getIncludedPage();
            return wikiPage.getData().getContent();
        }
        if (this.includingPage instanceof ProxyPage) {
            ProxyPage proxyPage = (ProxyPage)this.includingPage;
            String string = proxyPage.getHost();
            int n = proxyPage.getHostPort();
            try {
                ProxyPage proxyPage2 = new ProxyPage("RemoteIncludedPage", null, string, n, wikiPagePath);
                return proxyPage2.getData().getContent();
            }
            catch (Exception exception) {
                return "!meta '''Remote page " + string + ":" + n + "/" + this.pageName + " does not exist.'''";
            }
        }
        return "!meta '''Page include failed because the page " + this.pageName + " does not exist.'''";
    }

    protected WikiPage getIncludedPage() throws Exception {
        PageCrawler pageCrawler = this.parentPage.getPageCrawler();
        pageCrawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
        return pageCrawler.getPage(this.parentPage, PathParser.parse(this.pageName));
    }

    protected WikiPage getParentPage() throws Exception {
        return this.parent.getWikiPage().getParent();
    }

    private String getOption(Matcher matcher) {
        return matcher.group(1);
    }

    private String getPageName(Matcher matcher) {
        return matcher.group(2);
    }

    private void buildWidget(String string) throws Exception {
        String string2 = this.processLiterals(this.getIncludedPageContent());
        if ("-seamless".equals(string)) {
            this.addChildWidgets(string2 + "\n");
        } else {
            new CollapsableWidget(this, this.getPrefix(string) + this.pageName, string2, this.getCssClass(string), this.isCollapsed(string));
        }
    }

    private String getCssClass(String string) {
        return (String)optionCssMap.get(string);
    }

    private String getPrefix(String string) {
        return (String)optionPrefixMap.get(string);
    }

    private boolean isCollapsed(String string) throws Exception {
        if (this.isSetup(string) && this.isSetupCollapsed()) {
            return true;
        }
        if (this.isTeardown(string) && this.isTeardownCollapsed()) {
            return true;
        }
        return "-c".equals(string);
    }

    private static Map buildOptionsCssMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("-setup", "setup");
        hashMap.put("-teardown", "teardown");
        hashMap.put("-c", "included");
        hashMap.put(null, "included");
        return hashMap;
    }

    private static Map buildOptionPrefixMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("-setup", "Set Up: ");
        hashMap.put("-teardown", "Tear Down: ");
        hashMap.put("-c", "Included page: ");
        hashMap.put(null, "Included page: ");
        return hashMap;
    }

    private boolean isTeardownCollapsed() throws Exception {
        return "true".equals(this.parent.getVariable(COLLAPSE_TEARDOWN));
    }

    private boolean isTeardown(String string) {
        return "-teardown".equals(string);
    }

    private boolean isSetupCollapsed() throws Exception {
        return "true".equals(this.parent.getVariable(COLLAPSE_SETUP));
    }

    private boolean isSetup(String string) {
        return "-setup".equals(string);
    }

    public String render() throws Exception {
        return this.childHtml();
    }

    public WikiPage getReferencedPage() throws Exception {
        return this.getParentPage().getPageCrawler().getPage(this.getParentPage(), PathParser.parse(this.pageName));
    }
}

