/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.LinkWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageWidget
extends WikiWidget {
    public static final String REGEXP = "(?:!img(?:-[lr])? \\S+)|(?:https?://[^\\s]+[^\\s.)]+.(?:gif|jpg|GIF|JPG))";
    private static final Pattern pattern = Pattern.compile("(!img(-[lr])? )?(\\S*)");
    private String picturePath;
    private String alignment;
    private boolean usesBangImg;

    public ImageWidget(ParentWidget parentWidget, String string) {
        super(parentWidget);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.picturePath = LinkWidget.makeUrlUsable(matcher.group(3));
            boolean bl = this.usesBangImg = matcher.group(1) != null;
            if (this.usesBangImg) {
                this.alignment = matcher.group(2);
            }
        } else {
            System.err.println("ImagesWidget parse error: " + string);
        }
    }

    public String render() throws Exception {
        StringBuffer stringBuffer = new StringBuffer("<img src=\"");
        stringBuffer.append(this.picturePath).append("\"");
        if (this.alignment != null) {
            stringBuffer.append(" class=\"");
            if ("-l".equals(this.alignment)) {
                stringBuffer.append("left");
            } else {
                stringBuffer.append("right");
            }
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String asWikiText() throws Exception {
        String string = this.picturePath;
        if (string.startsWith("/files")) {
            string = "http:/" + string;
        }
        if (this.usesBangImg) {
            String string2 = this.alignment == null ? "" : this.alignment;
            return "!img" + string2 + " " + string;
        }
        return string;
    }
}

