/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.wikitext.widgets.BlankParentWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CollapsableWidget
extends ParentWidget {
    private static final String ENDL = "(?:(?:\r\n)|\n|\r)";
    public static final String REGEXP = "!\\*+>? .*?(?:(?:\r\n)|\n|\r).*?(?:(?:\r\n)|\n|\r)\\*+!(?:(?:\r\n)|\n|\r)?";
    private static final Pattern pattern = Pattern.compile("!\\*+(>)? (.*?)(?:(?:\r\n)|\n|\r)(.*?)(?:(?:\r\n)|\n|\r)\\*+!", 40);
    private static Random random = new Random();
    private String cssClass = "collapse_rim";
    private ParentWidget titleWidget;
    public boolean expanded = true;
    private static final String collapsableOpenCss = "collapsable";
    private static final String collapsableClosedCss = "hidden";
    private static final String collapsableOpenImg = "/files/images/collapsableOpen.gif";
    private static final String collapsableClosedImg = "/files/images/collapsableClosed.gif";
    private static final String collapseAllLink = "<a href=\"javascript:collapseAll();\">Collapse All</a>";
    private static final String expandAllLink = "<a href=\"javascript:expandAll();\">Expand All</a>";

    public CollapsableWidget(ParentWidget parentWidget) {
        super(parentWidget);
    }

    public CollapsableWidget(ParentWidget parentWidget, String string) throws Exception {
        this(parentWidget);
        Matcher matcher = pattern.matcher(string);
        matcher.find();
        this.expanded = matcher.group(1) == null;
        String string2 = matcher.group(2);
        String string3 = matcher.group(3);
        this.init(string2, string3);
    }

    public CollapsableWidget(ParentWidget parentWidget, String string, String string2, String string3, boolean bl) throws Exception {
        this(parentWidget);
        this.init(string, string2);
        this.cssClass = string3;
        this.expanded = !bl;
    }

    private void init(String string, String string2) throws Exception {
        this.titleWidget = new BlankParentWidget(this, "!meta " + string);
        this.addChildWidgets(string2);
    }

    public String render() throws Exception {
        RawHtml rawHtml = new RawHtml("&nbsp;" + this.titleWidget.childHtml());
        RawHtml rawHtml2 = new RawHtml(this.childHtml());
        HtmlTag htmlTag = this.makeCollapsableSection(rawHtml, rawHtml2);
        return ((HtmlElement)htmlTag).html();
    }

    public HtmlTag makeCollapsableSection(HtmlElement htmlElement, HtmlElement htmlElement2) {
        String string = random.nextLong() + "";
        HtmlTag htmlTag = HtmlUtil.makeDivTag(this.cssClass);
        HtmlTag htmlTag2 = new HtmlTag("img");
        htmlTag2.addAttribute("src", this.imageSrc());
        htmlTag2.addAttribute("class", "left");
        htmlTag2.addAttribute("id", "img" + string);
        HtmlTag htmlTag3 = new HtmlTag("a", htmlTag2);
        htmlTag3.addAttribute("href", "javascript:toggleCollapsable('" + string + "');");
        HtmlTag htmlTag4 = new HtmlTag("div");
        htmlTag4.addAttribute("style", "float: right;");
        htmlTag4.addAttribute("class", "meta");
        htmlTag4.add("<a href=\"javascript:expandAll();\">Expand All</a> | <a href=\"javascript:collapseAll();\">Collapse All</a>");
        htmlTag.add(htmlTag4);
        htmlTag.add(htmlTag3);
        htmlTag.add(htmlElement);
        HtmlTag htmlTag5 = this.makeCollapsableDiv();
        htmlTag5.addAttribute("id", string);
        htmlTag5.add(htmlElement2);
        htmlTag.add(htmlTag5);
        return htmlTag;
    }

    private HtmlTag makeCollapsableDiv() {
        if (!this.expanded) {
            return HtmlUtil.makeDivTag(collapsableClosedCss);
        }
        return HtmlUtil.makeDivTag(collapsableOpenCss);
    }

    private String imageSrc() {
        if (this.expanded) {
            return collapsableOpenImg;
        }
        return collapsableClosedImg;
    }
}

