/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.WidgetWithTextArgument;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClasspathWidget
extends ParentWidget
implements WidgetWithTextArgument {
    public static final String REGEXP = "^!path [^\r\n]*";
    private static final Pattern pattern = Pattern.compile("^!path (.*)");
    private String pathText;

    public ClasspathWidget(ParentWidget parentWidget, String string) throws Exception {
        super(parentWidget);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.pathText = matcher.group(1);
            this.addChildWidgets(this.pathText);
        }
    }

    public WidgetBuilder getBuilder() {
        return WidgetBuilder.variableWidgetBuilder;
    }

    public String render() throws Exception {
        return HtmlUtil.metaText("classpath: " + this.childHtml());
    }

    public String asWikiText() throws Exception {
        return "!path " + this.pathText;
    }

    public String getText() throws Exception {
        return this.childHtml();
    }
}

