/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.WidgetVisitor;
import fitnesse.wikitext.widgets.BlankParentWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.WikiWordWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AliasLinkWidget
extends ParentWidget {
    public static final String REGEXP = "\\[\\[[^\n\r\\]]+\\]\\[[^\n\r\\]]+\\]\\]";
    public static final Pattern pattern = Pattern.compile("\\[\\[([^\n\r\\]]+)\\]\\[([^\n\r\\]]+)\\]\\]");
    private String tag;
    private String href;
    WikiPage parentPage = this.getWikiPage().getParent();

    public AliasLinkWidget(ParentWidget parentWidget, String string) throws Exception {
        super(parentWidget);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.tag = matcher.group(1);
            this.href = matcher.group(2);
            this.addChildWidgets(this.tag);
        }
    }

    public String render() throws Exception {
        if (WikiWordWidget.isWikiWord(this.href)) {
            WikiWordWidget wikiWordWidget = new WikiWordWidget(new BlankParentWidget(this, ""), this.href);
            String string = wikiWordWidget.getWikiWord();
            WikiPagePath wikiPagePath = PathParser.parse(string);
            WikiPagePath wikiPagePath2 = this.parentPage.getPageCrawler().getFullPathOfChild(this.parentPage, wikiPagePath);
            String string2 = PathParser.render(wikiPagePath2);
            if (this.parentPage.getPageCrawler().pageExists(this.parentPage, PathParser.parse(string))) {
                return "<a href=\"" + string2 + "\">" + this.childHtml() + "</a>";
            }
            if (this.getWikiPage() instanceof ProxyPage) {
                return this.makeAliasLinkToNonExistentRemotePage(string);
            }
            return this.childHtml() + "<a href=\"" + string2 + "?edit\">?</a>";
        }
        return "<a href=\"" + this.href + "\">" + this.childHtml() + "</a>";
    }

    private String makeAliasLinkToNonExistentRemotePage(String string) throws Exception {
        ProxyPage proxyPage = (ProxyPage)this.getWikiPage();
        String string2 = proxyPage.getThisPageUrl();
        String string3 = proxyPage.getName();
        int n = string2.lastIndexOf(string3);
        String string4 = string2.substring(0, n);
        return this.childHtml() + "<a href=\"" + string4 + string + "?edit\"" + " target=\"" + string + "\"" + ">?</a>";
    }

    public String asWikiText() throws Exception {
        return "[[" + this.childWikiText() + "][" + this.href + "]]";
    }

    public void acceptVisitor(WidgetVisitor widgetVisitor) throws Exception {
        widgetVisitor.visit(this);
    }

    public void renamePageIfReferenced(WikiPage wikiPage, String string) throws Exception {
        if (WikiWordWidget.isWikiWord(this.href)) {
            WikiWordWidget wikiWordWidget = new WikiWordWidget(new BlankParentWidget(this, ""), this.href);
            wikiWordWidget.renamePageIfReferenced(wikiPage, string);
            this.href = wikiWordWidget.getText();
        }
    }
}

