/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext;

import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.AliasLinkWidget;
import fitnesse.wikitext.widgets.AnchorDeclarationWidget;
import fitnesse.wikitext.widgets.AnchorMarkerWidget;
import fitnesse.wikitext.widgets.BoldWidget;
import fitnesse.wikitext.widgets.CenterWidget;
import fitnesse.wikitext.widgets.ClasspathWidget;
import fitnesse.wikitext.widgets.CollapsableWidget;
import fitnesse.wikitext.widgets.CommentWidget;
import fitnesse.wikitext.widgets.EmailWidget;
import fitnesse.wikitext.widgets.FixtureWidget;
import fitnesse.wikitext.widgets.HeaderWidget;
import fitnesse.wikitext.widgets.HruleWidget;
import fitnesse.wikitext.widgets.ImageWidget;
import fitnesse.wikitext.widgets.IncludeWidget;
import fitnesse.wikitext.widgets.ItalicWidget;
import fitnesse.wikitext.widgets.LastModifiedWidget;
import fitnesse.wikitext.widgets.LineBreakWidget;
import fitnesse.wikitext.widgets.LinkWidget;
import fitnesse.wikitext.widgets.ListWidget;
import fitnesse.wikitext.widgets.LiteralWidget;
import fitnesse.wikitext.widgets.MetaWidget;
import fitnesse.wikitext.widgets.NoteWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.PreformattedWidget;
import fitnesse.wikitext.widgets.StrikeWidget;
import fitnesse.wikitext.widgets.TOCWidget;
import fitnesse.wikitext.widgets.TableWidget;
import fitnesse.wikitext.widgets.TextWidget;
import fitnesse.wikitext.widgets.VariableDefinitionWidget;
import fitnesse.wikitext.widgets.VariableWidget;
import fitnesse.wikitext.widgets.VirtualWikiWidget;
import fitnesse.wikitext.widgets.WikiWordWidget;
import fitnesse.wikitext.widgets.XRefWidget;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WidgetBuilder {
    public static final Class[] htmlWidgetClasses = new Class[]{CommentWidget.class, LiteralWidget.class, WikiWordWidget.class, BoldWidget.class, ItalicWidget.class, PreformattedWidget.class, HruleWidget.class, HeaderWidget.class, CenterWidget.class, NoteWidget.class, TableWidget.class, ListWidget.class, ClasspathWidget.class, LineBreakWidget.class, ImageWidget.class, LinkWidget.class, TOCWidget.class, AliasLinkWidget.class, VirtualWikiWidget.class, StrikeWidget.class, LastModifiedWidget.class, FixtureWidget.class, XRefWidget.class, MetaWidget.class, EmailWidget.class, AnchorDeclarationWidget.class, AnchorMarkerWidget.class, CollapsableWidget.class, IncludeWidget.class, VariableDefinitionWidget.class, VariableWidget.class};
    public static WidgetBuilder htmlWidgetBuilder = new WidgetBuilder(htmlWidgetClasses);
    public static WidgetBuilder literalAndVariableWidgetBuilder = new WidgetBuilder(new Class[]{LiteralWidget.class, VariableWidget.class});
    public static WidgetBuilder variableWidgetBuilder = new WidgetBuilder(new Class[]{VariableWidget.class});
    private Class[] widgetClasses;
    private Pattern widgetPattern;
    private WidgetData[] widgetDataArray;

    public WidgetBuilder(Class[] classArray) {
        this.widgetClasses = classArray;
        this.widgetPattern = this.buildCompositeWidgetPattern();
        this.widgetDataArray = this.buildWidgetDataArray();
    }

    private Pattern buildCompositeWidgetPattern() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.widgetClasses.length; ++i) {
            Class clazz = this.widgetClasses[i];
            String string = WidgetBuilder.getRegexpFromWidgetClass(clazz);
            stringBuffer.append("(").append(string).append(")");
            if (i == this.widgetClasses.length - 1) continue;
            stringBuffer.append("|");
        }
        return Pattern.compile(stringBuffer.toString(), 40);
    }

    private static String getRegexpFromWidgetClass(Class clazz) {
        String string = null;
        try {
            Field field = clazz.getField("REGEXP");
            string = (String)field.get(clazz);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public void addChildWidgets2(String string, ParentWidget parentWidget) throws Exception {
        Matcher matcher = this.getWidgetPattern().matcher(string);
        if (matcher.find()) {
            String string2 = string.substring(0, matcher.start());
            if (!"".equals(string2)) {
                new TextWidget(parentWidget, string2);
            }
            this.makeWidget(parentWidget, matcher);
            String string3 = string.substring(matcher.end());
            if (!string3.equals("")) {
                this.addChildWidgets(string3, parentWidget);
            }
        } else {
            new TextWidget(parentWidget, string);
        }
    }

    public WikiWidget makeWidget(ParentWidget parentWidget, Matcher matcher) throws Exception {
        int n = this.getGroupMatched(matcher);
        Class clazz = this.widgetClasses[n - 1];
        return this.constructWidget(clazz, parentWidget, matcher.group());
    }

    private WikiWidget constructWidget(Class clazz, ParentWidget parentWidget, String string) throws Exception {
        try {
            Constructor constructor = clazz.getConstructor(ParentWidget.class, String.class);
            return (WikiWidget)constructor.newInstance(parentWidget, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Exception exception2 = new Exception("Widget Construction failed for " + clazz.getName() + "\n" + exception.getMessage());
            exception2.setStackTrace(exception.getStackTrace());
            throw exception2;
        }
    }

    public int getGroupMatched(Matcher matcher) {
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            if (matcher.group(i) == null) continue;
            return i;
        }
        return -1;
    }

    public Pattern getWidgetPattern() {
        return this.widgetPattern;
    }

    private WidgetData[] buildWidgetDataArray() {
        WidgetData[] widgetDataArray = new WidgetData[this.widgetClasses.length];
        for (int i = 0; i < this.widgetClasses.length; ++i) {
            Class clazz = this.widgetClasses[i];
            widgetDataArray[i] = new WidgetData(clazz);
        }
        return widgetDataArray;
    }

    public void addChildWidgets(String string, ParentWidget parentWidget) throws Exception {
        WidgetData widgetData = this.findFirstMatch(string);
        if (widgetData != null) {
            Matcher matcher = widgetData.match;
            String string2 = string.substring(0, matcher.start());
            if (!"".equals(string2)) {
                new TextWidget(parentWidget, string2);
            }
            this.constructWidget(widgetData.widgetClass, parentWidget, matcher.group());
            String string3 = string.substring(matcher.end());
            if (!string3.equals("")) {
                this.addChildWidgets(string3, parentWidget);
            }
        } else {
            new TextWidget(parentWidget, string);
        }
    }

    private WidgetData findFirstMatch(String string) {
        this.resetWidgetDataList();
        WidgetData widgetData = null;
        for (int i = 0; i < this.widgetDataArray.length; ++i) {
            WidgetData widgetData2 = this.widgetDataArray[i];
            Matcher matcher = widgetData2.pattern.matcher(string);
            if (!matcher.find()) continue;
            widgetData2.match = matcher;
            if (widgetData == null) {
                widgetData = widgetData2;
                continue;
            }
            if (matcher.start() >= widgetData.match.start()) continue;
            widgetData = widgetData2;
        }
        return widgetData;
    }

    private void resetWidgetDataList() {
        for (int i = 0; i < this.widgetDataArray.length; ++i) {
            this.widgetDataArray[i].match = null;
        }
    }

    static class WidgetData {
        public Class widgetClass;
        public Pattern pattern;
        public Matcher match;

        public WidgetData(Class clazz) {
            this.widgetClass = clazz;
            this.pattern = Pattern.compile(WidgetBuilder.getRegexpFromWidgetClass(clazz), 40);
        }
    }
}

