/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.components.XmlWriter;
import fitnesse.util.XmlUtil;
import fitnesse.wiki.WikiPageProperty;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WikiPageProperties
extends WikiPageProperty
implements Serializable {
    public static final String VIRTUAL_WIKI_ATTRIBUTE = "VirtualWiki";
    private Map symbolicLinks;

    public WikiPageProperties() throws Exception {
        this.symbolicLinks = new HashMap();
    }

    public WikiPageProperties(InputStream inputStream) throws Exception {
        this();
        this.loadFromXmlStream(inputStream);
    }

    public WikiPageProperties(Element element) throws Exception {
        this();
        this.loadFromRootElement(element);
    }

    public WikiPageProperties(WikiPageProperties wikiPageProperties) throws Exception {
        if (wikiPageProperties != null && wikiPageProperties.children != null) {
            this.children = new HashMap(wikiPageProperties.children);
        }
        this.symbolicLinks = new HashMap(wikiPageProperties.symbolicLinks);
    }

    public void loadFromXmlStream(InputStream inputStream) throws Exception {
        Document document = XmlUtil.newDocument(inputStream);
        Element element = document.getDocumentElement();
        this.loadFromRootElement(element);
    }

    public void loadFromRootElement(Element element) throws Exception {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String string = node.getNodeName();
            this.LoadElement(this, (Element)node, string);
        }
    }

    private void LoadElement(WikiPageProperty wikiPageProperty, Element element, String string) {
        WikiPageProperty wikiPageProperty2 = new WikiPageProperty();
        wikiPageProperty.set(string, wikiPageProperty2);
        NodeList nodeList = element.getChildNodes();
        if (element.hasAttribute("value")) {
            wikiPageProperty2.setValue(element.getAttribute("value"));
        } else if (nodeList.getLength() == 1) {
            wikiPageProperty2.setValue(nodeList.item(0).getNodeValue());
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            this.LoadElement(wikiPageProperty2, (Element)node, node.getNodeName());
        }
    }

    public void save(OutputStream outputStream) throws Exception {
        Document document = XmlUtil.newDocument();
        document.appendChild(this.makeRootElement(document));
        XmlWriter xmlWriter = new XmlWriter(outputStream);
        xmlWriter.write(document);
        xmlWriter.flush();
        xmlWriter.close();
    }

    public Element makeRootElement(Document document) {
        Element element = document.createElement("properties");
        ArrayList arrayList = new ArrayList(this.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            WikiPageProperty wikiPageProperty = this.getProperty(string);
            this.toXml(wikiPageProperty, string, document, element);
        }
        return element;
    }

    private void toXml(WikiPageProperty wikiPageProperty, String string, Document document, Element element) {
        Element element2 = document.createElement(string);
        String string2 = wikiPageProperty.getValue();
        if (wikiPageProperty.hasChildren()) {
            if (string2 != null) {
                element2.setAttribute("value", string2);
            }
            Set set = wikiPageProperty.keySet();
            for (String string3 : set) {
                WikiPageProperty wikiPageProperty2 = wikiPageProperty.getProperty(string3);
                this.toXml(wikiPageProperty2, string3, document, element2);
            }
        } else if (string2 != null) {
            element2.appendChild(document.createTextNode(string2));
        }
        element.appendChild(element2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString("WikiPageProperties", 0));
        return stringBuffer.toString();
    }

    public Date getLastModificationTime() throws Exception {
        String string = this.get("LastModified");
        if (string == null) {
            return new Date();
        }
        return WikiPageProperties.getTimeFormat().parse(string);
    }

    public void setLastModificationTime(Date date) {
        this.set("LastModified", WikiPageProperties.getTimeFormat().format(date));
    }
}

