/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.util.StringUtil;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.WikiPage;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPagePath
implements Comparable,
Cloneable,
Serializable {
    public static final String ROOT = "_root";
    private LinkedList<String> names = new LinkedList();

    public WikiPagePath() {
    }

    public WikiPagePath(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addName(stringArray[i]);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        WikiPagePath wikiPagePath = new WikiPagePath();
        wikiPagePath.names = (LinkedList)this.names.clone();
        return wikiPagePath;
    }

    public WikiPagePath copy() {
        try {
            return (WikiPagePath)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public WikiPagePath(WikiPage wikiPage) throws Exception {
        PageCrawler pageCrawler = wikiPage.getPageCrawler();
        while (!pageCrawler.isRoot(wikiPage)) {
            this.names.addFirst(wikiPage.getName());
            wikiPage = wikiPage.getParent();
        }
    }

    public WikiPagePath(WikiPagePath wikiPagePath) {
        WikiPagePath wikiPagePath2 = wikiPagePath;
        while (!wikiPagePath2.isEmpty()) {
            this.addName(wikiPagePath2.getFirst());
            wikiPagePath2 = wikiPagePath2.getRest();
        }
    }

    private WikiPagePath(List<String> list) {
        this.names = new LinkedList<String>(list);
    }

    public String getFirst() {
        return this.isEmpty() ? null : this.names.get(0);
    }

    public WikiPagePath addName(String string) {
        this.names.add(string);
        return this;
    }

    public WikiPagePath addNameToFront(String string) {
        this.names.addFirst(string);
        return this;
    }

    public WikiPagePath getRest() {
        int n = this.names.size();
        return n <= 1 ? new WikiPagePath() : new WikiPagePath(this.names.subList(1, n));
    }

    public boolean isEmpty() {
        return this.names.size() == 0;
    }

    public String last() {
        return this.names.size() == 0 ? null : this.names.get(this.names.size() - 1);
    }

    public List<String> getNames() {
        return this.names;
    }

    public String toString() {
        return "(" + StringUtil.join(this.names, ".") + ")";
    }

    public void pop() {
        if (this.names.size() > 0) {
            this.names.removeLast();
        }
    }

    public WikiPagePath append(WikiPagePath wikiPagePath) {
        WikiPagePath wikiPagePath2 = new WikiPagePath(this);
        WikiPagePath wikiPagePath3 = wikiPagePath;
        while (!wikiPagePath3.isEmpty()) {
            wikiPagePath2.addName(wikiPagePath3.getFirst());
            wikiPagePath3 = wikiPagePath3.getRest();
        }
        return wikiPagePath2;
    }

    public boolean isAbsolute() {
        return !this.isEmpty() && ROOT.equals(this.getFirst());
    }

    public void makeAbsolute() {
        if (!this.isAbsolute()) {
            this.addNameToFront(ROOT);
        }
    }

    public int hashCode() {
        return StringUtil.join(this.names, "").hashCode();
    }

    public WikiPagePath relativePath() {
        if (this.isAbsolute()) {
            return this.getRest();
        }
        return this;
    }

    public int compareTo(Object object) {
        if (object instanceof WikiPagePath) {
            WikiPagePath wikiPagePath = (WikiPagePath)object;
            String string = StringUtil.join(this.names, "");
            String string2 = StringUtil.join(wikiPagePath.names, "");
            return string.compareTo(string2);
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (object instanceof WikiPagePath) {
            WikiPagePath wikiPagePath = (WikiPagePath)object;
            return this.names.equals(wikiPagePath.names);
        }
        return false;
    }

    public WikiPagePath parentPath() {
        WikiPagePath wikiPagePath = new WikiPagePath(this);
        wikiPagePath.pop();
        return wikiPagePath;
    }

    public boolean startsWith(WikiPagePath wikiPagePath) {
        if (wikiPagePath.names.size() > this.names.size()) {
            return false;
        }
        Iterator iterator = this.names.iterator();
        for (String string : wikiPagePath.names) {
            Object e = iterator.next();
            if (e.equals(string)) continue;
            return false;
        }
        return true;
    }

    public WikiPagePath withNameAdded(String string) {
        WikiPagePath wikiPagePath = new WikiPagePath(this);
        wikiPagePath.addName(string);
        return wikiPagePath;
    }

    public WikiPagePath subtract(WikiPagePath wikiPagePath) {
        WikiPagePath wikiPagePath2 = new WikiPagePath(this);
        if (wikiPagePath2.startsWith(wikiPagePath)) {
            for (String string : wikiPagePath.getNames()) {
                if (!string.equals(wikiPagePath2.getFirst())) break;
                wikiPagePath2.names.removeFirst();
            }
        }
        return wikiPagePath2;
    }
}

