/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.responders.ErrorResponder;
import fitnesse.wiki.Extension;
import fitnesse.wiki.NullVirtualCouplingPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.VirtualCouplingPage;
import fitnesse.wiki.WikiPage;

public class VirtualCouplingExtension
implements Extension {
    public static final String NAME = "VirtualCoupling";
    private WikiPage hostPage;
    protected VirtualCouplingPage virtualCoupling;

    public String getName() {
        return NAME;
    }

    public VirtualCouplingExtension(WikiPage wikiPage) throws Exception {
        this.hostPage = wikiPage;
        this.resetVirtualCoupling();
    }

    public void setVirtualCoupling(VirtualCouplingPage virtualCouplingPage) {
        this.virtualCoupling = virtualCouplingPage;
    }

    public void resetVirtualCoupling() throws Exception {
        this.virtualCoupling = new NullVirtualCouplingPage(this.hostPage);
    }

    public WikiPage getVirtualCoupling() throws Exception {
        this.detectAndLoadVirtualChildren();
        return this.virtualCoupling;
    }

    protected void detectAndLoadVirtualChildren() throws Exception {
        PageData pageData = this.hostPage.getData();
        if (pageData.hasAttribute("VirtualWiki")) {
            this.loadVirtualChildren(pageData.getAttribute("VirtualWiki"));
        }
    }

    public void loadVirtualChildren(String string) throws Exception {
        try {
            ProxyPage proxyPage = ProxyPage.retrievePage(string);
            this.virtualCoupling = new VirtualCouplingPage(this.hostPage, proxyPage);
        }
        catch (Exception exception) {
            WikiPage wikiPage = this.hostPage.getChildPage("VirtualWikiNetworkError");
            if (wikiPage == null) {
                wikiPage = this.hostPage.addChildPage("VirtualWikiNetworkError");
            }
            PageData pageData = wikiPage.getData();
            pageData.setContent("{{{" + ErrorResponder.makeExceptionString(exception) + "}}}");
            wikiPage.commit(pageData);
        }
    }
}

