/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionInfo
implements Comparable,
Serializable {
    public static final Pattern COMPEX_NAME_PATTERN = Pattern.compile("(?:([a-zA-Z][^\\-]*)-)?(?:\\d+-)?(\\d{14})");
    private static int counter = 0;
    private String name;
    private String author;
    private Date creationTime;

    public static SimpleDateFormat makeVersionTimeFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss");
    }

    public static int nextId() {
        return counter++;
    }

    public VersionInfo(String string, String string2, Date date) {
        this.name = string;
        this.author = string2;
        this.creationTime = date;
    }

    public VersionInfo(String string) throws Exception {
        this(string, "", new Date());
        Matcher matcher = COMPEX_NAME_PATTERN.matcher(string);
        if (matcher.find()) {
            this.author = matcher.group(1);
            if (this.author == null) {
                this.author = "";
            }
            this.creationTime = VersionInfo.makeVersionTimeFormat().parse(matcher.group(2));
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public String getName() {
        return this.name;
    }

    public static String getVersionNumber(String string) {
        Matcher matcher = COMPEX_NAME_PATTERN.matcher(string);
        matcher.find();
        return matcher.group(2);
    }

    public int compareTo(Object object) {
        if (object instanceof VersionInfo) {
            VersionInfo versionInfo = (VersionInfo)object;
            return this.getCreationTime().compareTo(versionInfo.getCreationTime());
        }
        return 0;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof VersionInfo) {
            VersionInfo versionInfo = (VersionInfo)object;
            return this.getName().equals(versionInfo.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

