/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.http.ResponseParser;
import fitnesse.wiki.CachingPage;
import fitnesse.wiki.NoSuchVersionException;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ProxyPage
extends CachingPage
implements Serializable {
    public static int retrievalCount = 0;
    private String host;
    private int hostPort;
    private WikiPagePath realPath;
    public ResponseParser parser;
    private long lastLoadChildrenTime = 0L;

    public ProxyPage(WikiPage wikiPage) throws Exception {
        super(wikiPage.getName(), null);
        this.realPath = wikiPage.getPageCrawler().getFullPath(wikiPage);
        List<WikiPage> list = wikiPage.getChildren();
        Iterator<WikiPage> iterator = list.iterator();
        while (iterator.hasNext()) {
            ProxyPage proxyPage = new ProxyPage(iterator.next());
            proxyPage.parent = this;
            this.children.put(proxyPage.getName(), proxyPage);
        }
    }

    protected ProxyPage(String string, WikiPage wikiPage) throws Exception {
        super(string, wikiPage);
    }

    public ProxyPage(String string, WikiPage wikiPage, String string2, int n, WikiPagePath wikiPagePath) throws Exception {
        super(string, wikiPage);
        this.host = string2;
        this.hostPort = n;
        this.realPath = wikiPagePath;
    }

    public static ProxyPage retrievePage(String string) throws Exception {
        ++retrievalCount;
        URL uRL = new URL(string + "?responder=proxy&type=bones");
        ProxyPage proxyPage = (ProxyPage)ProxyPage.getObjectFromUrl(uRL);
        proxyPage.setTransientValues(uRL.getHost(), new Date().getTime());
        int n = uRL.getPort();
        proxyPage.setHostPort(n == -1 ? 80 : n);
        proxyPage.lastLoadChildrenTime = System.currentTimeMillis();
        return proxyPage;
    }

    protected WikiPage createChildPage(String string) throws Exception {
        WikiPagePath wikiPagePath = this.realPath.copy().addName(string);
        return new ProxyPage(string, this, this.host, this.getHostPort(), wikiPagePath);
    }

    protected void loadChildren() throws Exception {
        if ((long)cacheTime <= System.currentTimeMillis() - this.lastLoadChildrenTime) {
            ProxyPage proxyPage = ProxyPage.retrievePage(this.getThisPageUrl());
            this.children.clear();
            for (ProxyPage proxyPage2 : proxyPage.children.values()) {
                proxyPage2.parent = this;
                this.children.put(proxyPage2.getName(), proxyPage2);
            }
            this.lastLoadChildrenTime = System.currentTimeMillis();
        }
    }

    public String getThisPageUrl() {
        StringBuffer stringBuffer = new StringBuffer("http://");
        stringBuffer.append(this.host);
        stringBuffer.append(":").append(this.getHostPort());
        stringBuffer.append("/").append(PathParser.render(this.realPath));
        return stringBuffer.toString();
    }

    public boolean hasChildPage(String string) throws Exception {
        if (this.children.containsKey(string)) {
            return true;
        }
        this.loadChildren();
        return this.children.containsKey(string);
    }

    public void setTransientValues(String string, long l) {
        this.host = string;
        this.lastLoadChildrenTime = l;
        for (ProxyPage proxyPage : this.children.values()) {
            proxyPage.setTransientValues(string, l);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHostPort(int n) {
        this.hostPort = n;
        for (ProxyPage proxyPage : this.children.values()) {
            proxyPage.setHostPort(n);
        }
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public PageData getMeat() throws Exception {
        return this.getMeat(null);
    }

    public PageData getMeat(String string) throws Exception {
        URL uRL;
        PageData pageData;
        StringBuffer stringBuffer = new StringBuffer(this.getThisPageUrl());
        stringBuffer.append("?responder=proxy&type=meat");
        if (string != null) {
            stringBuffer.append("&version=").append(string);
        }
        if ((pageData = (PageData)ProxyPage.getObjectFromUrl(uRL = new URL(stringBuffer.toString()))) != null) {
            pageData.setWikiPage(this);
        }
        return pageData;
    }

    private static Object getObjectFromUrl(URL uRL) throws Exception {
        InputStream inputStream = uRL.openStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    protected PageData makePageData() throws Exception {
        return this.getMeat();
    }

    public PageData getDataVersion(String string) throws Exception {
        PageData pageData = this.getMeat(string);
        if (pageData == null) {
            throw new NoSuchVersionException("There is no version '" + string + "'");
        }
        return pageData;
    }

    protected VersionInfo makeVersion() throws Exception {
        return null;
    }

    protected void doCommit(PageData pageData) throws Exception {
    }
}

