/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.WikiPagePath;
import java.util.Iterator;
import java.util.regex.Pattern;

public class PathParser {
    public static final String PATH_SEPARATOR = ".";
    private static final Pattern wikiWordPattern = Pattern.compile("(?:\\^|\\./|(?:\\.\\./)+)?(?:[./]?\\b[A-Z](?:[a-z0-9]+[A-Z][a-z0-9]*)+)+\\b");
    private WikiPagePath path;

    public static WikiPagePath parse(String string) {
        return new PathParser().makePath(string);
    }

    private WikiPagePath makePath(String string) {
        this.path = new WikiPagePath();
        if (string.equals("")) {
            return this.path;
        }
        if (string.equals("root") || string.equals(PATH_SEPARATOR)) {
            this.path.addName("_root");
            return this.path;
        }
        return this.parsePathName(string);
    }

    private WikiPagePath parsePathName(String string) {
        if (string.startsWith(PATH_SEPARATOR)) {
            this.path.addName("_root");
            string = string.substring(1);
        }
        String[] stringArray = string.split("\\.");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!PathParser.nameIsValid(string2)) {
                return null;
            }
            this.path.addName(string2);
        }
        return this.path;
    }

    private static boolean nameIsValid(String string) {
        return wikiWordPattern.matcher(string).matches();
    }

    public static String render(WikiPagePath wikiPagePath) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = wikiPagePath.getNames().iterator();
        if (iterator.hasNext()) {
            String string = iterator.next();
            if (!string.equals("_root")) {
                stringBuffer.append(string);
            } else if (!iterator.hasNext()) {
                stringBuffer.append(PATH_SEPARATOR);
            }
        }
        while (iterator.hasNext()) {
            stringBuffer.append(PATH_SEPARATOR).append((Object)iterator.next());
        }
        return stringBuffer.toString();
    }
}

