/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.util.XmlUtil;
import fitnesse.wiki.MockWikiPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.XmlizePageCondition;
import fitnesse.wiki.XmlizerPageHandler;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PageXmlizer {
    private static SimpleDateFormat dateFormat = WikiPageProperty.getTimeFormat();
    private LinkedList<XmlizePageCondition> pageConditions = new LinkedList();

    public Document xmlize(WikiPage wikiPage) throws Exception {
        Document document = XmlUtil.newDocument();
        Element element = this.createXmlFromPage(document, wikiPage);
        document.appendChild(element);
        return document;
    }

    public void deXmlize(Document document, WikiPage wikiPage, XmlizerPageHandler xmlizerPageHandler) throws Exception {
        Element element = document.getDocumentElement();
        this.addChildFromXml(element, wikiPage, xmlizerPageHandler);
    }

    public void deXmlizeSkippingRootLevel(Document document, WikiPage wikiPage, XmlizerPageHandler xmlizerPageHandler) throws Exception {
        Element element = document.getDocumentElement();
        this.addChildrenFromXml(element, wikiPage, xmlizerPageHandler);
    }

    public Document xmlize(PageData pageData) throws Exception {
        Document document = XmlUtil.newDocument();
        Element element = document.createElement("data");
        XmlUtil.addCdataNode(document, element, "content", pageData.getContent());
        Element element2 = pageData.getProperties().makeRootElement(document);
        element.appendChild(element2);
        document.appendChild(element);
        return document;
    }

    public PageData deXmlizeData(Document document) throws Exception {
        PageData pageData = new PageData(new MockWikiPage());
        Element element = document.getDocumentElement();
        String string = XmlUtil.getLocalTextValue(element, "content");
        pageData.setContent(string);
        Element element2 = XmlUtil.getLocalElementByTagName(element, "properties");
        WikiPageProperties wikiPageProperties = new WikiPageProperties(element2);
        pageData.setProperties(wikiPageProperties);
        return pageData;
    }

    private void addPageXmlToElement(Document document, Element element, WikiPage wikiPage) throws Exception {
        if (this.pageMeetsConditions(wikiPage)) {
            element.appendChild(this.createXmlFromPage(document, wikiPage));
        }
    }

    private boolean pageMeetsConditions(WikiPage wikiPage) throws Exception {
        for (XmlizePageCondition xmlizePageCondition : this.pageConditions) {
            if (xmlizePageCondition.canBeXmlized(wikiPage)) continue;
            return false;
        }
        return true;
    }

    private Element createXmlFromPage(Document document, WikiPage wikiPage) throws Exception {
        Element element = document.createElement("page");
        XmlUtil.addTextNode(document, element, "name", wikiPage.getName());
        this.addLastModifiedTag(wikiPage, document, element);
        this.addXmlFromChildren(wikiPage, document, element);
        return element;
    }

    private void addLastModifiedTag(WikiPage wikiPage, Document document, Element element) throws Exception {
        Date date = wikiPage.getData().getProperties().getLastModificationTime();
        String string = dateFormat.format(date);
        XmlUtil.addTextNode(document, element, "lastModified", string);
    }

    private void addXmlFromChildren(WikiPage wikiPage, Document document, Element element) throws Exception {
        Element element2 = document.createElement("children");
        List<WikiPage> list = wikiPage.getChildren();
        Collections.sort(list);
        for (WikiPage wikiPage2 : list) {
            this.addPageXmlToElement(document, element2, wikiPage2);
        }
        element.appendChild(element2);
    }

    private void addChildFromXml(Element element, WikiPage wikiPage, XmlizerPageHandler xmlizerPageHandler) throws Exception {
        String string = XmlUtil.getTextValue(element, "name");
        String string2 = XmlUtil.getTextValue(element, "lastModified");
        Date date = string2 == null ? new Date(0L) : dateFormat.parse(string2);
        WikiPage wikiPage2 = wikiPage.getChildPage(string);
        if (wikiPage2 == null) {
            wikiPage2 = wikiPage.addChildPage(string);
        }
        xmlizerPageHandler.enterChildPage(wikiPage2, date);
        this.addChildrenFromXml(element, wikiPage2, xmlizerPageHandler);
        xmlizerPageHandler.exitPage();
    }

    private void addChildrenFromXml(Element element, WikiPage wikiPage, XmlizerPageHandler xmlizerPageHandler) throws Exception {
        Element element2 = XmlUtil.getLocalElementByTagName(element, "children");
        NodeList nodeList = element2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"page".equals(node.getNodeName())) continue;
            this.addChildFromXml((Element)node, wikiPage, xmlizerPageHandler);
        }
    }

    public void addPageCondition(XmlizePageCondition xmlizePageCondition) {
        this.pageConditions.add(xmlizePageCondition);
    }
}

