/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.VersionInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class PageVersionPruner {
    public static int daysTillVersionsExpire = 14;

    public static void pruneVersions(FileSystemPage fileSystemPage, Collection collection) throws Exception {
        List list = PageVersionPruner.makeSortedVersionList(collection);
        if (collection.size() > 0) {
            VersionInfo versionInfo = (VersionInfo)list.get(list.size() - 1);
            GregorianCalendar gregorianCalendar = PageVersionPruner.makeVersionExpirationDate(versionInfo);
            for (VersionInfo versionInfo2 : list) {
                PageVersionPruner.removeVersionIfExpired(fileSystemPage, versionInfo2, gregorianCalendar);
            }
        }
    }

    private static List makeSortedVersionList(Collection collection) throws Exception {
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList);
        return arrayList;
    }

    private static GregorianCalendar makeVersionExpirationDate(VersionInfo versionInfo) throws Exception {
        Date date = versionInfo.getCreationTime();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.add(5, -daysTillVersionsExpire);
        return gregorianCalendar;
    }

    private static void removeVersionIfExpired(FileSystemPage fileSystemPage, VersionInfo versionInfo, GregorianCalendar gregorianCalendar) throws Exception {
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(versionInfo.getCreationTime());
        if (gregorianCalendar2.before(gregorianCalendar) || ((Calendar)gregorianCalendar2).equals(gregorianCalendar)) {
            fileSystemPage.removeVersion(versionInfo.getName());
        }
    }
}

