/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.components.SaveRecorder;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.ClasspathWidget;
import fitnesse.wikitext.widgets.FixtureWidget;
import fitnesse.wikitext.widgets.IncludeWidget;
import fitnesse.wikitext.widgets.TextIgnoringWidgetRoot;
import fitnesse.wikitext.widgets.VariableDefinitionWidget;
import fitnesse.wikitext.widgets.WidgetRoot;
import fitnesse.wikitext.widgets.WidgetWithTextArgument;
import fitnesse.wikitext.widgets.XRefWidget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PageData
implements Serializable {
    public static WidgetBuilder classpathWidgetBuilder = new WidgetBuilder(new Class[]{IncludeWidget.class, VariableDefinitionWidget.class, ClasspathWidget.class});
    public static WidgetBuilder fixtureWidgetBuilder = new WidgetBuilder(new Class[]{FixtureWidget.class});
    public static WidgetBuilder xrefWidgetBuilder = new WidgetBuilder(new Class[]{XRefWidget.class});
    public static WidgetBuilder variableDefinitionWidgetBuilder = new WidgetBuilder(new Class[]{IncludeWidget.class, VariableDefinitionWidget.class});
    private transient WikiPage wikiPage;
    private String content;
    private WikiPageProperties properties = new WikiPageProperties();
    private Set versions;
    private WidgetRoot variableRoot;

    public PageData(WikiPage wikiPage) throws Exception {
        this.wikiPage = wikiPage;
        this.initializeAttributes();
        this.versions = new HashSet();
    }

    public PageData(WikiPage wikiPage, String string) throws Exception {
        this(wikiPage);
        this.setContent(string);
    }

    public PageData(PageData pageData) throws Exception {
        this(pageData.getWikiPage());
        this.wikiPage = pageData.wikiPage;
        this.content = pageData.content;
        this.properties = new WikiPageProperties(pageData.properties);
        this.versions.addAll(pageData.versions);
    }

    public String getStringOfAllAttributes() {
        return this.properties.toString();
    }

    public void initializeAttributes() throws Exception {
        this.properties.set("Edit", "true");
        this.properties.set("Versions", "true");
        this.properties.set("Properties", "true");
        this.properties.set("Refactor", "true");
        this.properties.set("WhereUsed", "true");
        this.properties.set("Files", "true");
        this.properties.set("RecentChanges", "true");
        this.properties.set("Search", "true");
        this.properties.set("ticketId", SaveRecorder.newTicket() + "");
        this.properties.setLastModificationTime(new Date());
        String string = this.wikiPage.getName();
        if (string.startsWith("Test")) {
            this.properties.set("Test", "true");
        }
        if (string.startsWith("Suite") && !string.equals("SuiteSetUp") && !string.equals("SuiteTearDown")) {
            this.properties.set("Suite", "true");
        }
    }

    public WikiPageProperties getProperties() throws Exception {
        return this.properties;
    }

    public String getAttribute(String string) throws Exception {
        return this.properties.get(string);
    }

    public void removeAttribute(String string) throws Exception {
        this.properties.remove(string);
    }

    public void setAttribute(String string, String string2) throws Exception {
        this.properties.set(string, string2);
    }

    public void setAttribute(String string) throws Exception {
        this.properties.set(string);
    }

    public boolean hasAttribute(String string) throws Exception {
        return this.properties.has(string);
    }

    public void setProperties(WikiPageProperties wikiPageProperties) {
        this.properties = wikiPageProperties;
    }

    public String getContent() throws Exception {
        return this.content;
    }

    public void setContent(String string) throws Exception {
        this.content = string;
    }

    public String getHtml() throws Exception {
        return this.processHTMLWidgets(this.getContent(), this.wikiPage);
    }

    public String getHtml(WikiPage wikiPage) throws Exception {
        return this.processHTMLWidgets(this.getContent(), wikiPage);
    }

    public String getVariable(String string) throws Exception {
        if (this.variableRoot == null) {
            this.variableRoot = new TextIgnoringWidgetRoot(this.getContent(), this.wikiPage, variableDefinitionWidgetBuilder);
            this.variableRoot.render();
        }
        return this.variableRoot.getVariable(string);
    }

    private String processHTMLWidgets(String string, WikiPage wikiPage) throws Exception {
        WidgetRoot widgetRoot = new WidgetRoot(string, wikiPage, WidgetBuilder.htmlWidgetBuilder);
        return widgetRoot.render();
    }

    public void setWikiPage(WikiPage wikiPage) {
        this.wikiPage = wikiPage;
    }

    public WikiPage getWikiPage() {
        return this.wikiPage;
    }

    public List getClasspaths() throws Exception {
        return this.getTextOfWidgets(classpathWidgetBuilder);
    }

    public List getFixtureNames() throws Exception {
        return this.getTextOfWidgets(fixtureWidgetBuilder);
    }

    public List getXrefPages() throws Exception {
        return this.getTextOfWidgets(xrefWidgetBuilder);
    }

    private List getTextOfWidgets(WidgetBuilder widgetBuilder) throws Exception {
        TextIgnoringWidgetRoot textIgnoringWidgetRoot = new TextIgnoringWidgetRoot(this.getContent(), this.wikiPage, widgetBuilder);
        List list = textIgnoringWidgetRoot.getChildren();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : list) {
            if (e instanceof WidgetWithTextArgument) {
                arrayList.add(((WidgetWithTextArgument)e).getText());
                continue;
            }
            if (!(e instanceof WikiWidget)) continue;
            ((WikiWidget)e).render();
        }
        return arrayList;
    }

    public Set getVersions() {
        return this.versions;
    }

    public void addVersions(Collection collection) {
        this.versions.addAll(collection);
    }
}

