/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.components.FitNesseTraversalListener;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageCrawlerDeadEndStrategy;
import fitnesse.wiki.PageData;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageUtil;
import java.util.LinkedList;
import java.util.List;

public class PageCrawlerImpl
implements PageCrawler {
    private PageCrawlerDeadEndStrategy deadEndStrategy;

    protected PageCrawlerImpl() {
    }

    public WikiPage getPage(WikiPage wikiPage, WikiPagePath wikiPagePath) throws Exception {
        if (wikiPagePath == null) {
            return null;
        }
        if (wikiPagePath.isEmpty()) {
            return wikiPage;
        }
        String string = wikiPagePath.getFirst();
        WikiPagePath wikiPagePath2 = wikiPagePath.getRest();
        if (string.equals("_root")) {
            return this.getPage(this.getRoot(wikiPage), wikiPagePath2);
        }
        WikiPage wikiPage2 = wikiPage.getChildPage(string);
        if (wikiPage2 != null) {
            return this.getPage(wikiPage2, wikiPagePath2);
        }
        return this.getPageAfterDeadEnd(wikiPage, string, wikiPagePath2);
    }

    protected WikiPage getPageAfterDeadEnd(WikiPage wikiPage, String string, WikiPagePath wikiPagePath) throws Exception {
        wikiPagePath.addNameToFront(string);
        if (this.deadEndStrategy != null) {
            return this.deadEndStrategy.getPageAfterDeadEnd(wikiPage, wikiPagePath, this);
        }
        return null;
    }

    public void setDeadEndStrategy(PageCrawlerDeadEndStrategy pageCrawlerDeadEndStrategy) {
        this.deadEndStrategy = pageCrawlerDeadEndStrategy;
    }

    public boolean pageExists(WikiPage wikiPage, WikiPagePath wikiPagePath) throws Exception {
        return this.getPage(wikiPage, wikiPagePath) != null;
    }

    public WikiPagePath getFullPathOfChild(WikiPage wikiPage, WikiPagePath wikiPagePath) throws Exception {
        WikiPagePath wikiPagePath2;
        if (wikiPagePath.isAbsolute()) {
            wikiPagePath2 = wikiPagePath.relativePath();
        } else {
            WikiPagePath wikiPagePath3 = new WikiPagePath(wikiPage);
            wikiPagePath2 = wikiPagePath3.append(wikiPagePath);
        }
        return wikiPagePath2;
    }

    public WikiPagePath getFullPath(WikiPage wikiPage) throws Exception {
        return new WikiPagePath(wikiPage);
    }

    public WikiPage addPage(WikiPage wikiPage, WikiPagePath wikiPagePath, String string) throws Exception {
        WikiPage wikiPage2 = this.addPage(wikiPage, wikiPagePath);
        if (wikiPage2 != null) {
            PageData pageData = new PageData(wikiPage2);
            pageData.setContent(string);
            wikiPage2.commit(pageData);
        }
        return wikiPage2;
    }

    public WikiPage addPage(WikiPage wikiPage, WikiPagePath wikiPagePath) throws Exception {
        return this.getOrMakePage(wikiPage, wikiPagePath.getNames());
    }

    private WikiPage getOrMakePage(WikiPage wikiPage, List list) throws Exception {
        String string = (String)list.get(0);
        List list2 = list.subList(1, list.size());
        WikiPage wikiPage2 = wikiPage.getChildPage(string) == null ? wikiPage.addChildPage(string) : wikiPage.getChildPage(string);
        if (list2.size() == 0) {
            return wikiPage2;
        }
        return this.getOrMakePage(wikiPage2, list2);
    }

    public String getRelativeName(WikiPage wikiPage, WikiPage wikiPage2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        for (WikiPage wikiPage3 = wikiPage2; !this.isRoot(wikiPage3) && wikiPage3 != wikiPage; wikiPage3 = wikiPage3.getParent()) {
            if (wikiPage3 != wikiPage2) {
                stringBuffer.insert(0, ".");
            }
            stringBuffer.insert(0, wikiPage3.getName());
        }
        return stringBuffer.toString();
    }

    public static WikiPage getInheritedPage(String string, WikiPage wikiPage) throws Exception {
        LinkedList linkedList = WikiPageUtil.getAncestorsStartingWith(wikiPage);
        for (WikiPage wikiPage2 : linkedList) {
            WikiPage wikiPage3 = wikiPage2.getChildPage(string);
            if (wikiPage3 == null) continue;
            return wikiPage3;
        }
        return null;
    }

    public boolean isRoot(WikiPage wikiPage) throws Exception {
        WikiPage wikiPage2 = wikiPage.getParent();
        return wikiPage2 == null || wikiPage2 == wikiPage;
    }

    public WikiPage getRoot(WikiPage wikiPage) throws Exception {
        if (this.isRoot(wikiPage)) {
            return wikiPage;
        }
        return this.getRoot(wikiPage.getParent());
    }

    public void traverse(WikiPage wikiPage, FitNesseTraversalListener fitNesseTraversalListener) throws Exception {
        if (wikiPage.getClass() == SymbolicPage.class) {
            return;
        }
        fitNesseTraversalListener.processPage(wikiPage);
        List<WikiPage> list = wikiPage.getChildren();
        for (WikiPage wikiPage2 : list) {
            this.traverse(wikiPage2, fitNesseTraversalListener);
        }
    }
}

