/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.CommitingPage;
import fitnesse.wiki.NoSuchVersionException;
import fitnesse.wiki.PageData;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.VirtualCouplingExtension;
import fitnesse.wiki.WikiPage;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class InMemoryPage
extends CommitingPage {
    protected static final String currentVersionName = "current_version";
    protected Map versions = new HashMap();
    protected Map children = new HashMap();

    protected InMemoryPage(String string, String string2, WikiPage wikiPage) throws Exception {
        super(string, wikiPage);
        this.addExtention(new VirtualCouplingExtension(this));
        this.versions.put(currentVersionName, new PageData(this, string2));
    }

    public WikiPage addChildPage(String string) throws Exception {
        WikiPage wikiPage = this.createChildPage(string);
        this.children.put(string, wikiPage);
        return wikiPage;
    }

    public static WikiPage makeRoot(String string) throws Exception {
        InMemoryPage inMemoryPage = new InMemoryPage(string, "", null);
        return inMemoryPage;
    }

    public static WikiPage makeRoot(Properties properties) throws Exception {
        return InMemoryPage.makeRoot(properties.getProperty("FitNesseRoot", "FitNesseRoot"));
    }

    protected WikiPage createChildPage(String string) throws Exception {
        InMemoryPage inMemoryPage = new InMemoryPage(string, "", this);
        this.children.put(inMemoryPage.getName(), inMemoryPage);
        return inMemoryPage;
    }

    public void removeChildPage(String string) throws Exception {
        this.children.remove(string);
    }

    public boolean hasChildPage(String string) {
        return this.children.containsKey(string);
    }

    protected VersionInfo makeVersion() throws Exception {
        PageData pageData = this.getDataVersion(currentVersionName);
        String string = String.valueOf(VersionInfo.nextId());
        VersionInfo versionInfo = this.makeVersionInfo(pageData, string);
        this.versions.put(versionInfo.getName(), pageData);
        return versionInfo;
    }

    protected WikiPage getNormalChildPage(String string) throws Exception {
        return (WikiPage)this.children.get(string);
    }

    public List getNormalChildren() throws Exception {
        return new LinkedList(this.children.values());
    }

    public PageData getData() throws Exception {
        return new PageData(this.getDataVersion(currentVersionName));
    }

    public void doCommit(PageData pageData) throws Exception {
        pageData.setWikiPage(this);
        pageData.getProperties().setLastModificationTime(new Date());
        this.versions.put(currentVersionName, pageData);
    }

    public PageData getDataVersion(String string) throws Exception {
        PageData pageData = (PageData)this.versions.get(string);
        if (pageData == null) {
            throw new NoSuchVersionException("There is no version '" + string + "'");
        }
        HashSet hashSet = new HashSet(this.versions.keySet());
        hashSet.remove(currentVersionName);
        LinkedList<VersionInfo> linkedList = new LinkedList<VersionInfo>();
        for (String string2 : hashSet) {
            PageData pageData2 = (PageData)this.versions.get(string2);
            linkedList.add(this.makeVersionInfo(pageData2, string2));
        }
        pageData.addVersions(linkedList);
        return new PageData(pageData);
    }

    public int numberOfVersions() {
        return this.versions.size() - 1;
    }

    protected VersionInfo makeVersionInfo(PageData pageData, String string) throws Exception {
        String string2 = pageData.getAttribute("LastModifyingUser");
        if (string2 == null) {
            string2 = "";
        }
        Date date = pageData.getProperties().getLastModificationTime();
        VersionInfo versionInfo = new VersionInfo(string, string2, date);
        return versionInfo;
    }
}

