/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.util.FileUtil;
import fitnesse.util.StreamReader;
import fitnesse.wiki.CachingPage;
import fitnesse.wiki.NoSuchVersionException;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageVersionPruner;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wikitext.widgets.WikiWordWidget;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FileSystemPage
extends CachingPage {
    public static final String contentFilename = "/content.txt";
    public static final String propertiesFilename = "/properties.xml";
    private String path;

    protected FileSystemPage(String string, String string2, WikiPage wikiPage) throws Exception {
        super(string2, wikiPage);
        this.path = string;
    }

    public static WikiPage makeRoot(String string, String string2) throws Exception {
        return new FileSystemPage(string, string2, null);
    }

    public void removeChildPage(String string) throws Exception {
        super.removeChildPage(string);
        File file = new File(this.getFileSystemPath() + "/" + string);
        FileUtil.deleteFileSystemDirectory(file);
    }

    public boolean hasChildPage(String string) throws Exception {
        File file = new File(this.getFileSystemPath() + "/" + string);
        if (file.exists()) {
            this.addChildPage(string);
            return true;
        }
        return false;
    }

    protected synchronized void saveContent(String string) throws Exception {
        if (string == null) {
            return;
        }
        String string2 = System.getProperty("line.separator");
        if (string.endsWith("|")) {
            string = string + string2;
        }
        string = string.replaceAll("\r\n", string2);
        File file = new File(this.getFileSystemPath() + contentFilename);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        outputStreamWriter.write(string);
        outputStreamWriter.close();
    }

    protected synchronized void saveAttributes(WikiPageProperties wikiPageProperties) throws Exception {
        String string = this.getFileSystemPath() + propertiesFilename;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        wikiPageProperties.save(fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    protected WikiPage createChildPage(String string) throws Exception {
        FileSystemPage fileSystemPage = new FileSystemPage(this.getFileSystemPath(), string, this);
        new File(fileSystemPage.getFileSystemPath()).mkdirs();
        return fileSystemPage;
    }

    private void loadContent(PageData pageData) throws Exception {
        String string = "";
        String string2 = this.getFileSystemPath() + contentFilename;
        File file = new File(string2);
        if (file.exists()) {
            byte[] byArray = new byte[(int)file.length()];
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
            fileInputStream.close();
            string = new String(byArray, "UTF-8");
        }
        pageData.setContent(string);
    }

    protected void loadChildren() throws Exception {
        File file = new File(this.getFileSystemPath());
        if (file.exists()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!this.fileIsValid(string, file) || this.children.containsKey(string)) continue;
                this.children.put(string, this.getChildPage(string));
            }
        }
    }

    private boolean fileIsValid(String string, File file) {
        File file2;
        return WikiWordWidget.isWikiWord(string) && (file2 = new File(file, string)).isDirectory();
    }

    private String getParentFileSystemPath() throws Exception {
        return this.parent != null ? ((FileSystemPage)this.parent).getFileSystemPath() : this.path;
    }

    public String getFileSystemPath() throws Exception {
        return this.getParentFileSystemPath() + "/" + this.getName();
    }

    private void loadAttributes(PageData pageData) throws Exception {
        File file = new File(this.getFileSystemPath() + propertiesFilename);
        if (file.exists()) {
            try {
                this.attemptToReadPropertiesFile(file, pageData);
            }
            catch (Exception exception) {
                System.err.println("Could not read properties file:" + file.getPath());
                exception.printStackTrace();
            }
        }
    }

    private void attemptToReadPropertiesFile(File file, PageData pageData) throws Exception {
        WikiPageProperties wikiPageProperties = new WikiPageProperties();
        FileInputStream fileInputStream = new FileInputStream(file);
        wikiPageProperties.loadFromXmlStream(fileInputStream);
        ((InputStream)fileInputStream).close();
        pageData.setProperties(wikiPageProperties);
    }

    public void doCommit(PageData pageData) throws Exception {
        pageData.getProperties().setLastModificationTime(new Date());
        this.saveContent(pageData.getContent());
        this.saveAttributes(pageData.getProperties());
        PageVersionPruner.pruneVersions(this, this.loadVersions());
    }

    protected PageData makePageData() throws Exception {
        PageData pageData = new PageData(this);
        this.loadContent(pageData);
        this.loadAttributes(pageData);
        pageData.addVersions(this.loadVersions());
        return pageData;
    }

    public PageData getDataVersion(String string) throws Exception {
        String string2 = this.getFileSystemPath() + "/" + string + ".zip";
        File file = new File(string2);
        if (!file.exists()) {
            throw new NoSuchVersionException("There is no version '" + string + "'");
        }
        PageData pageData = new PageData(this);
        ZipFile zipFile = new ZipFile(file);
        this.loadVersionContent(zipFile, pageData);
        this.loadVersionAttributes(zipFile, pageData);
        pageData.addVersions(this.loadVersions());
        zipFile.close();
        return pageData;
    }

    private Collection loadVersions() throws Exception {
        File file = new File(this.getFileSystemPath());
        File[] fileArray = file.listFiles();
        HashSet<VersionInfo> hashSet = new HashSet<VersionInfo>();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!this.isVersionFile(file2)) continue;
                hashSet.add(new VersionInfo(this.makeVersionName(file2)));
            }
        }
        return hashSet;
    }

    protected VersionInfo makeVersion() throws Exception {
        PageData pageData = this.getData();
        return this.makeVersion(pageData);
    }

    protected VersionInfo makeVersion(PageData pageData) throws Exception {
        String string = this.getFileSystemPath();
        Set set = this.getFilesToZip(string);
        VersionInfo versionInfo = this.makeVersionInfo(pageData);
        if (set.size() == 0) {
            return new VersionInfo("first_commit", "", new Date());
        }
        String string2 = this.makeVersionFileName(versionInfo.getName());
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string2));
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.addToZip((File)iterator.next(), zipOutputStream);
        }
        zipOutputStream.finish();
        zipOutputStream.close();
        return new VersionInfo(versionInfo.getName());
    }

    protected VersionInfo makeVersionInfo(PageData pageData) throws Exception {
        Date date = pageData.getProperties().getLastModificationTime();
        String string = VersionInfo.nextId() + "-" + FileSystemPage.dateFormat().format(date);
        String string2 = pageData.getAttribute("LastModifyingUser");
        if (string2 != null && !"".equals(string2)) {
            string = string2 + "-" + string;
        }
        return new VersionInfo(string, string2, date);
    }

    public static SimpleDateFormat dateFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss");
    }

    protected String makeVersionFileName(String string) throws Exception {
        return this.getFileSystemPath() + "/" + string + ".zip";
    }

    protected String makeVersionName(File file) {
        String string = file.getName();
        return string.substring(0, string.length() - 4);
    }

    protected boolean isVersionFile(File file) {
        return Pattern.matches("(\\S+)?\\d+\\.zip", file.getName());
    }

    protected void removeVersion(String string) throws Exception {
        String string2 = this.makeVersionFileName(string);
        File file = new File(string2);
        file.delete();
    }

    protected Set getFilesToZip(String string) {
        HashSet<File> hashSet = new HashSet<File>();
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return hashSet;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (this.isVersionFile(file2) || file2.isDirectory()) continue;
            hashSet.add(file2);
        }
        return hashSet;
    }

    private void addToZip(File file, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(file.getName());
        zipOutputStream.putNextEntry(zipEntry);
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray);
        fileInputStream.close();
        zipOutputStream.write(byArray, 0, n);
    }

    protected void loadVersionContent(ZipFile zipFile, PageData pageData) throws Exception {
        String string = "";
        ZipEntry zipEntry = zipFile.getEntry("content.txt");
        if (zipEntry != null) {
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            StreamReader streamReader = new StreamReader(inputStream);
            string = streamReader.read((int)zipEntry.getSize());
            streamReader.close();
        }
        pageData.setContent(string);
    }

    protected void loadVersionAttributes(ZipFile zipFile, PageData pageData) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry("properties.xml");
        if (zipEntry != null) {
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            WikiPageProperties wikiPageProperties = new WikiPageProperties(inputStream);
            inputStream.close();
            pageData.setProperties(wikiPageProperties);
        }
    }

    public String toString() {
        try {
            return this.getClass().getName() + " at " + this.getFileSystemPath();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }
}

