/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.CommitingPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.VirtualCouplingExtension;
import fitnesse.wiki.WikiPage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class CachingPage
extends CommitingPage {
    public static int cacheTime = 3000;
    protected HashMap children = new HashMap();
    private transient SoftReference cachedData;
    private transient long cachedDataCreationTime = 0L;

    public CachingPage(String string, WikiPage wikiPage) throws Exception {
        super(string, wikiPage);
        this.addExtention(new VirtualCouplingExtension(this));
    }

    public abstract boolean hasChildPage(String var1) throws Exception;

    protected abstract WikiPage createChildPage(String var1) throws Exception;

    protected abstract void loadChildren() throws Exception;

    protected abstract PageData makePageData() throws Exception;

    public WikiPage addChildPage(String string) throws Exception {
        WikiPage wikiPage = this.createChildPage(string);
        this.children.put(string, wikiPage);
        return wikiPage;
    }

    public List getNormalChildren() throws Exception {
        this.loadChildren();
        return this.getCachedChildren();
    }

    public List getCachedChildren() throws Exception {
        return new ArrayList(this.children.values());
    }

    public void removeChildPage(String string) throws Exception {
        if (this.hasCachedSubpage(string)) {
            this.children.remove(string);
        }
    }

    public WikiPage getNormalChildPage(String string) throws Exception {
        if (this.hasCachedSubpage(string) || this.hasChildPage(string)) {
            return (WikiPage)this.children.get(string);
        }
        return null;
    }

    protected boolean hasCachedSubpage(String string) {
        return this.children.containsKey(string);
    }

    public PageData getData() throws Exception {
        if (this.cachedDataExpired()) {
            PageData pageData = this.makePageData();
            this.setCachedData(pageData);
        }
        return new PageData(this.getCachedData());
    }

    private boolean cachedDataExpired() throws Exception {
        long l = System.currentTimeMillis();
        return this.getCachedData() == null || l >= this.cachedDataCreationTime + (long)cacheTime;
    }

    public void dumpExpiredCachedData() throws Exception {
        if (this.cachedDataExpired()) {
            this.cachedData.clear();
            this.cachedData = null;
        }
    }

    public VersionInfo commit(PageData pageData) throws Exception {
        VersionInfo versionInfo = super.commit(pageData);
        this.setCachedData(this.makePageData());
        return versionInfo;
    }

    private void setCachedData(PageData pageData) throws Exception {
        if (this.cachedData != null) {
            this.cachedData.clear();
        }
        this.cachedData = new SoftReference<PageData>(pageData);
        this.cachedDataCreationTime = System.currentTimeMillis();
    }

    public PageData getCachedData() throws Exception {
        if (this.cachedData != null) {
            return (PageData)this.cachedData.get();
        }
        return null;
    }
}

