/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.util.FileUtil;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import java.io.File;
import java.util.List;

public abstract class BaseWikiPage
implements WikiPage {
    protected String name;
    protected WikiPage parent;

    protected BaseWikiPage(String string, WikiPage wikiPage) {
        this.name = string;
        this.parent = wikiPage;
    }

    public String getName() throws Exception {
        return this.name;
    }

    public PageCrawler getPageCrawler() {
        return new PageCrawlerImpl();
    }

    public WikiPage getParent() throws Exception {
        return this.parent == null ? this : this.parent;
    }

    protected abstract List getNormalChildren() throws Exception;

    public List getChildren() throws Exception {
        List list = this.getNormalChildren();
        WikiPageProperties wikiPageProperties = this.getData().getProperties();
        WikiPageProperty wikiPageProperty = wikiPageProperties.getProperty("SymbolicLinks");
        if (wikiPageProperty != null) {
            for (String string : wikiPageProperty.keySet()) {
                WikiPage wikiPage = this.createSymbolicPage(wikiPageProperty, string);
                if (wikiPage == null) continue;
                list.add(wikiPage);
            }
        }
        return list;
    }

    private WikiPage createSymbolicPage(WikiPageProperty wikiPageProperty, String string) throws Exception {
        if (wikiPageProperty == null) {
            return null;
        }
        String string2 = wikiPageProperty.get(string);
        if (string2 == null) {
            return null;
        }
        if (string2.startsWith("file://")) {
            return this.createExternalSymbolicLink(string2, string);
        }
        return this.createInternalSymbolicPage(string2, string);
    }

    private WikiPage createExternalSymbolicLink(String string, String string2) throws Exception {
        String string3 = string.substring(7);
        File file = new File(string3);
        File file2 = file.getParentFile();
        if (file2.exists()) {
            if (!file.exists()) {
                FileUtil.makeDir(file.getPath());
            }
            if (file.isDirectory()) {
                WikiPage wikiPage = FileSystemPage.makeRoot(file2.getPath(), file.getName());
                return new SymbolicPage(string2, wikiPage, this);
            }
        }
        return null;
    }

    private WikiPage createInternalSymbolicPage(String string, String string2) throws Exception {
        WikiPagePath wikiPagePath = PathParser.parse(string);
        PageCrawler pageCrawler = this.getPageCrawler();
        WikiPage wikiPage = pageCrawler.getPage(pageCrawler.getRoot(this), wikiPagePath);
        if (wikiPage != null) {
            wikiPage = new SymbolicPage(string2, wikiPage, this);
        }
        return wikiPage;
    }

    protected abstract WikiPage getNormalChildPage(String var1) throws Exception;

    public WikiPage getChildPage(String string) throws Exception {
        WikiPage wikiPage = this.getNormalChildPage(string);
        if (wikiPage == null) {
            wikiPage = this.createSymbolicPage(this.getData().getProperties().getProperty("SymbolicLinks"), string);
        }
        return wikiPage;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.name;
    }

    public int compareTo(Object object) {
        try {
            return this.getName().compareTo(((WikiPage)object).getName());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WikiPage)) {
            return false;
        }
        try {
            PageCrawler pageCrawler = this.getPageCrawler();
            return pageCrawler.getFullPath(this).equals(pageCrawler.getFullPath((WikiPage)object));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getPageCrawler().getFullPath(this).hashCode();
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

