/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.util;

import fitnesse.components.XmlWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlUtil {
    private static DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public static DocumentBuilder getDocumentBuilder() throws Exception {
        return documentBuilderFactory.newDocumentBuilder();
    }

    public static Document newDocument() throws Exception {
        return XmlUtil.getDocumentBuilder().newDocument();
    }

    public static Document newDocument(InputStream inputStream) throws Exception {
        return XmlUtil.getDocumentBuilder().parse(inputStream);
    }

    public static Document newDocument(String string) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        return XmlUtil.newDocument(byteArrayInputStream);
    }

    public static Element getElementByTagName(Element element, String string) throws Exception {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    public static Element getLocalElementByTagName(Element element, String string) throws Exception {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !string.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    public static String getTextValue(Element element, String string) throws Exception {
        Element element2 = XmlUtil.getElementByTagName(element, string);
        return XmlUtil.getElementText(element2, string);
    }

    public static String getLocalTextValue(Element element, String string) throws Exception {
        Element element2 = XmlUtil.getLocalElementByTagName(element, string);
        return XmlUtil.getElementText(element2, string);
    }

    private static String getElementText(Element element, String string) throws Exception {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        if (node instanceof Text) {
            return node.getNodeValue();
        }
        throw new Exception("The first child of " + string + " is not a Text node");
    }

    public static void addTextNode(Document document, Element element, String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            Element element2 = document.createElement(string);
            Text text = document.createTextNode(string2);
            element2.appendChild(text);
            element.appendChild(element2);
        }
    }

    public static void addCdataNode(Document document, Element element, String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            Element element2 = document.createElement(string);
            CDATASection cDATASection = document.createCDATASection(string2);
            element2.appendChild(cDATASection);
            element.appendChild(element2);
        }
    }

    public static String xmlAsString(Document document) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlWriter xmlWriter = new XmlWriter(byteArrayOutputStream);
        xmlWriter.write(document);
        xmlWriter.flush();
        xmlWriter.close();
        String string = byteArrayOutputStream.toString();
        return string;
    }
}

