/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamReader {
    private InputStream input;
    private State state;
    ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    OutputStream output;
    private int readGoal;
    private int readStatus;
    private boolean eof = false;
    private byte[] boundary;
    private int boundaryLength;
    private int matchingBoundaryIndex;
    private byte[] matchedBoundaryBytes;
    private long bytesConsumed;
    private final State READLINE_STATE = new State(){

        public void read(InputStream inputStream) throws Exception {
            int n = inputStream.read();
            if (n == -1) {
                StreamReader.this.changeState(StreamReader.this.FINAL_STATE);
                StreamReader.this.eof = true;
            } else {
                StreamReader.this.bytesConsumed++;
                if (n == 10) {
                    StreamReader.this.changeState(StreamReader.this.FINAL_STATE);
                } else if (n != 13) {
                    StreamReader.this.output.write((byte)n);
                }
            }
        }
    };
    private final State READCOUNT_STATE = new State(){

        public void read(InputStream inputStream) throws Exception {
            byte[] byArray = new byte[StreamReader.this.readGoal - StreamReader.this.readStatus];
            int n = inputStream.read(byArray);
            if (n < 0) {
                StreamReader.this.changeState(StreamReader.this.FINAL_STATE);
                StreamReader.this.eof = true;
            } else {
                StreamReader.this.bytesConsumed += n;
                StreamReader.this.readStatus += n;
                StreamReader.this.output.write(byArray, 0, n);
            }
        }

        public boolean finished() {
            return StreamReader.this.readStatus >= StreamReader.this.readGoal;
        }
    };
    private final State READUPTO_STATE = new State(){

        public void read(InputStream inputStream) throws Exception {
            int n = inputStream.read();
            if (n == -1) {
                StreamReader.this.changeState(StreamReader.this.FINAL_STATE);
                StreamReader.this.eof = true;
            } else {
                StreamReader.this.bytesConsumed++;
                if (n == StreamReader.this.boundary[StreamReader.this.matchingBoundaryIndex]) {
                    ((StreamReader)StreamReader.this).matchedBoundaryBytes[((StreamReader)StreamReader.this).matchingBoundaryIndex++] = (byte)n;
                    if (StreamReader.this.matchingBoundaryIndex >= StreamReader.this.boundaryLength) {
                        StreamReader.this.changeState(StreamReader.this.FINAL_STATE);
                    }
                } else if (StreamReader.this.matchingBoundaryIndex == 0) {
                    StreamReader.this.output.write((byte)n);
                } else {
                    StreamReader.this.output.write(StreamReader.this.matchedBoundaryBytes, 0, StreamReader.this.matchingBoundaryIndex);
                    StreamReader.this.matchingBoundaryIndex = 0;
                    if (n == StreamReader.this.boundary[StreamReader.this.matchingBoundaryIndex]) {
                        ((StreamReader)StreamReader.this).matchedBoundaryBytes[((StreamReader)StreamReader.this).matchingBoundaryIndex++] = (byte)n;
                    } else {
                        StreamReader.this.output.write((byte)n);
                    }
                }
            }
        }
    };
    private final State FINAL_STATE = new State(){

        public boolean finished() {
            return true;
        }
    };

    public StreamReader(InputStream inputStream) {
        this.input = inputStream;
    }

    public void close() throws Exception {
        this.input.close();
    }

    public String readLine() throws Exception {
        return this.bytesToString(this.readLineBytes());
    }

    public byte[] readLineBytes() throws Exception {
        this.state = this.READLINE_STATE;
        return this.preformRead();
    }

    public String read(int n) throws Exception {
        return this.bytesToString(this.readBytes(n));
    }

    public byte[] readBytes(int n) throws Exception {
        this.readGoal = n;
        this.readStatus = 0;
        this.state = this.READCOUNT_STATE;
        return this.preformRead();
    }

    public void copyBytes(int n, OutputStream outputStream) throws Exception {
        this.readGoal = n;
        this.state = this.READCOUNT_STATE;
        this.performCopy(outputStream);
    }

    public String readUpTo(String string) throws Exception {
        return this.bytesToString(this.readBytesUpTo(string));
    }

    public byte[] readBytesUpTo(String string) throws Exception {
        this.prepareForReadUpTo(string);
        return this.preformRead();
    }

    private void prepareForReadUpTo(String string) {
        this.boundary = string.getBytes();
        this.boundaryLength = this.boundary.length;
        this.matchedBoundaryBytes = new byte[this.boundaryLength];
        this.matchingBoundaryIndex = 0;
        this.state = this.READUPTO_STATE;
    }

    public void copyBytesUpTo(String string, OutputStream outputStream) throws Exception {
        this.prepareForReadUpTo(string);
        this.performCopy(outputStream);
    }

    public int byteCount() {
        return this.byteBuffer.size();
    }

    public byte[] getBufferedBytes() {
        return this.byteBuffer.toByteArray();
    }

    private byte[] preformRead() throws Exception {
        this.setReadMode();
        this.clearBuffer();
        this.readUntilFinished();
        return this.getBufferedBytes();
    }

    private void performCopy(OutputStream outputStream) throws Exception {
        this.setCopyMode(outputStream);
        this.readUntilFinished();
    }

    private void readUntilFinished() throws Exception {
        while (!this.state.finished()) {
            this.state.read(this.input);
        }
    }

    private void clearBuffer() {
        this.byteBuffer.reset();
    }

    private void setCopyMode(OutputStream outputStream) {
        this.output = outputStream;
    }

    private void setReadMode() {
        this.output = this.byteBuffer;
    }

    private String bytesToString(byte[] byArray) throws Exception {
        return new String(byArray, "UTF-8");
    }

    private void changeState(State state) {
        this.state = state;
    }

    public boolean isEof() {
        return this.eof;
    }

    public long numberOfBytesConsumed() {
        return this.bytesConsumed;
    }

    public void resetNumberOfBytesConsumed() {
        this.bytesConsumed = 0L;
    }

    private static abstract class State {
        private State() {
        }

        public void read(InputStream inputStream) throws Exception {
        }

        public boolean finished() {
            return false;
        }
    }
}

