/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.util;

import fitnesse.util.StreamReader;
import fitnesse.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class FileUtil {
    public static final String ENDL = System.getProperty("line.separator");

    public static File createFile(String string, String string2) {
        return FileUtil.createFile(new File(string), string2);
    }

    public static File createFile(File file, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file;
    }

    public static boolean makeDir(String string) {
        return new File(string).mkdir();
    }

    public static void deleteFileSystemDirectory(String string) {
        FileUtil.deleteFileSystemDirectory(new File(string));
    }

    public static void deleteFileSystemDirectory(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                FileUtil.deleteFileSystemDirectory(file2);
                continue;
            }
            FileUtil.deleteFile(file2);
        }
        FileUtil.deleteFile(file);
    }

    public static void deleteFile(String string) {
        FileUtil.deleteFile(new File(string));
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (!file.delete()) {
            throw new RuntimeException("Could not delete '" + file.getAbsoluteFile() + "'");
        }
        FileUtil.waitUntilFileDeleted(file);
    }

    private static void waitUntilFileDeleted(File file) {
        int n = 10;
        while (file.exists()) {
            if (--n <= 0) {
                System.out.println("Breaking out of delete wait");
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static String getFileContent(String string) throws Exception {
        File file = new File(string);
        return FileUtil.getFileContent(file);
    }

    public static String getFileContent(File file) throws Exception {
        return new String(FileUtil.getFileBytes(file));
    }

    public static byte[] getFileBytes(File file) throws Exception {
        long l = file.length();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new StreamReader(fileInputStream).readBytes((int)l);
        fileInputStream.close();
        return byArray;
    }

    public static LinkedList getFileLines(String string) throws Exception {
        return FileUtil.getFileLines(new File(string));
    }

    public static LinkedList getFileLines(File file) throws Exception {
        String string;
        LinkedList<String> linkedList = new LinkedList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            linkedList.add(string);
        }
        bufferedReader.close();
        return linkedList;
    }

    public static void writeLinesToFile(String string, List list) throws Exception {
        FileUtil.writeLinesToFile(new File(string), list);
    }

    public static void writeLinesToFile(File file, List list) throws Exception {
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        for (String string : list) {
            printStream.println(string);
        }
        printStream.close();
    }

    public static void copyBytes(InputStream inputStream, OutputStream outputStream) throws Exception {
        StreamReader streamReader = new StreamReader(inputStream);
        while (!streamReader.isEof()) {
            outputStream.write(streamReader.readBytes(1000));
        }
    }

    public static File createDir(String string) {
        FileUtil.makeDir(string);
        return new File(string);
    }

    public static File[] getDirectoryListing(File file) {
        TreeSet<File> treeSet = new TreeSet<File>();
        TreeSet<File> treeSet2 = new TreeSet<File>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                treeSet.add(fileArray[i]);
                continue;
            }
            treeSet2.add(fileArray[i]);
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        linkedList.addAll(treeSet);
        linkedList.addAll(treeSet2);
        return linkedList.toArray(new File[0]);
    }

    public static String buildPath(String[] stringArray) {
        return StringUtil.join(Arrays.asList(stringArray), System.getProperty("file.separator"));
    }
}

