/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.responders.WikiImportProperty;
import fitnesse.updates.PageTraversingUpdate;
import fitnesse.updates.Updater;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;

public class WikiImportPropertyFormatUpdate
extends PageTraversingUpdate {
    public WikiImportPropertyFormatUpdate(Updater updater) {
        super(updater);
    }

    public void processPage(WikiPage wikiPage) throws Exception {
        PageData pageData = wikiPage.getData();
        WikiPageProperties wikiPageProperties = pageData.getProperties();
        if (wikiPageProperties.has("WikiImportSource")) {
            String string = wikiPageProperties.get("WikiImportSource");
            WikiImportProperty wikiImportProperty = new WikiImportProperty(string);
            wikiImportProperty.addTo(wikiPageProperties);
            wikiPageProperties.remove("WikiImportSource");
            wikiPage.commit(pageData);
        } else if (wikiPageProperties.has("WikiImportRoot")) {
            String string = wikiPageProperties.get("WikiImportRoot");
            WikiImportProperty wikiImportProperty = new WikiImportProperty(string);
            wikiImportProperty.setRoot(true);
            wikiImportProperty.addTo(wikiPageProperties);
            wikiPageProperties.remove("WikiImportRoot");
            wikiPage.commit(pageData);
        }
    }

    public String getName() {
        return "WikiImportFormatUpdate";
    }

    public String getMessage() {
        return "Updating the format of WikiImport properties";
    }
}

