/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.FitNesseContext;
import fitnesse.updates.AttributeAdderUpdate;
import fitnesse.updates.FileUpdate;
import fitnesse.updates.FrontPageUpdate;
import fitnesse.updates.PropertiesToXmlUpdate;
import fitnesse.updates.ReplacingFileUpdate;
import fitnesse.updates.SymLinkPropertyFormatUpdate;
import fitnesse.updates.Update;
import fitnesse.updates.VirtualWikiDeprecationUpdate;
import fitnesse.updates.WikiImportPropertyFormatUpdate;
import fitnesse.wiki.WikiPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class Updater {
    public static boolean testing = false;
    public FitNesseContext context;
    public Properties rootProperties;
    public Update[] updates;

    public Updater(FitNesseContext fitNesseContext) throws Exception {
        this.context = fitNesseContext;
        this.rootProperties = this.loadProperties();
        this.updates = new Update[]{new ReplacingFileUpdate(this, "files/images/FitNesseLogo.gif", "files/images"), new ReplacingFileUpdate(this, "files/images/FitNesseLogoMedium.jpg", "files/images"), new ReplacingFileUpdate(this, "files/images/virtualPage.jpg", "files/images"), new ReplacingFileUpdate(this, "files/images/importedPage.jpg", "files/images"), new ReplacingFileUpdate(this, "files/images/collapsableOpen.gif", "files/images"), new ReplacingFileUpdate(this, "files/images/collapsableClosed.gif", "files/images"), new ReplacingFileUpdate(this, "files/images/folder.gif", "files/images"), new ReplacingFileUpdate(this, "files/images/executionStatus/ok.gif", "files/images/executionStatus"), new ReplacingFileUpdate(this, "files/images/executionStatus/output.gif", "files/images/executionStatus"), new ReplacingFileUpdate(this, "files/images/executionStatus/error.gif", "files/images/executionStatus"), new ReplacingFileUpdate(this, "files/css/fitnesse_base.css", "files/css"), new FileUpdate(this, "files/css/fitnesse.css", "files/css"), new FileUpdate(this, "files/css/fitnesse_print.css", "files/css"), new ReplacingFileUpdate(this, "files/javascript/fitnesse.js", "files/javascript"), new ReplacingFileUpdate(this, "files/javascript/clientSideSort.js", "files/javascript"), new ReplacingFileUpdate(this, "files/javascript/SpreadsheetTranslator.js", "files/javascript"), new ReplacingFileUpdate(this, "files/javascript/spreadsheetSupport.js", "files/javascript"), new PropertiesToXmlUpdate(this), new AttributeAdderUpdate(this, "RecentChanges"), new AttributeAdderUpdate(this, "WhereUsed"), new AttributeAdderUpdate(this, "Files"), new SymLinkPropertyFormatUpdate(this), new WikiImportPropertyFormatUpdate(this), new VirtualWikiDeprecationUpdate(this), new FrontPageUpdate(this)};
    }

    public void update() throws Exception {
        Update[] updateArray = this.getUpdates();
        for (int i = 0; i < updateArray.length; ++i) {
            Update update = updateArray[i];
            if (!update.shouldBeApplied()) continue;
            this.performUpdate(update);
        }
        this.saveProperties();
    }

    private void performUpdate(Update update) throws Exception {
        try {
            this.print(update.getMessage());
            update.doUpdate();
            this.print("...done\n");
        }
        catch (Exception exception) {
            this.print("\n\t" + exception + "\n");
        }
    }

    private Update[] getUpdates() throws Exception {
        return this.updates;
    }

    public WikiPage getRoot() {
        return this.context.root;
    }

    public Properties getProperties() {
        return this.rootProperties;
    }

    public Properties loadProperties() throws Exception {
        Properties properties = new Properties();
        File file = this.getPropertiesFile();
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        return properties;
    }

    private File getPropertiesFile() throws Exception {
        String string = this.context.rootPagePath + "/properties";
        return new File(string);
    }

    public void saveProperties() throws Exception {
        File file = this.getPropertiesFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.rootProperties.store(fileOutputStream, "FitNesse properties");
        ((OutputStream)fileOutputStream).close();
    }

    private void print(String string) {
        if (!testing) {
            System.out.print(string);
        }
    }
}

