/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.updates.PageTraversingUpdate;
import fitnesse.updates.Updater;
import fitnesse.util.FileUtil;
import fitnesse.util.XmlUtil;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SymLinkPropertyFormatUpdate
extends PageTraversingUpdate {
    public SymLinkPropertyFormatUpdate(Updater updater) {
        super(updater);
    }

    public void processPage(WikiPage wikiPage) throws Exception {
        try {
            FileSystemPage fileSystemPage = (FileSystemPage)wikiPage;
            String string = FileUtil.getFileContent(fileSystemPage.getFileSystemPath() + "/properties.xml");
            if (string.contains("<symbolicLink>")) {
                this.fixPropertiesFile(fileSystemPage, string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fixPropertiesFile(FileSystemPage fileSystemPage, String string) throws Exception {
        PageData pageData = fileSystemPage.getData();
        WikiPageProperty wikiPageProperty = this.getSymbolicLinkProperty(pageData);
        pageData.getProperties().remove("symbolicLink");
        Document document = XmlUtil.newDocument(string);
        NodeList nodeList = document.getElementsByTagName("symbolicLink");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string2 = XmlUtil.getLocalTextValue(element, "name");
            String string3 = XmlUtil.getLocalTextValue(element, "path");
            wikiPageProperty.set(string2, string3);
        }
        fileSystemPage.commit(pageData);
    }

    private WikiPageProperty getSymbolicLinkProperty(PageData pageData) throws Exception {
        WikiPageProperties wikiPageProperties = pageData.getProperties();
        WikiPageProperty wikiPageProperty = wikiPageProperties.getProperty("SymbolicLinks");
        if (wikiPageProperty == null) {
            wikiPageProperty = wikiPageProperties.set("SymbolicLinks");
        }
        return wikiPageProperty;
    }

    public String getName() {
        return "SymLinkPropertyFormatUpdate";
    }

    public String getMessage() {
        return "Updating the format of SybolicLink properties";
    }
}

