/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.updates.PageTraversingUpdate;
import fitnesse.updates.Updater;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class PropertiesToXmlUpdate
extends PageTraversingUpdate {
    public static final String old_propertiesFilename = "/properties";

    public PropertiesToXmlUpdate(Updater updater) {
        super(updater);
    }

    public String getMessage() {
        return "Converting properties files to XML";
    }

    public String getName() {
        return "PropertiesToXmlUpdate";
    }

    public void processPage(WikiPage wikiPage) throws Exception {
        FileSystemPage fileSystemPage = (FileSystemPage)wikiPage;
        String string = fileSystemPage.getFileSystemPath();
        File file = new File(string + old_propertiesFilename);
        Properties properties = this.loadOldProperties(file);
        this.saveNewProperties(string, properties);
        file.delete();
    }

    private void saveNewProperties(String string, Properties properties) throws Exception {
        File file = new File(string + "/properties.xml");
        WikiPageProperties wikiPageProperties = new WikiPageProperties();
        for (String string2 : properties.keySet()) {
            String string3 = (String)properties.get(string2);
            if ("false".equals(string3)) continue;
            wikiPageProperties.set(string2, string3);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        wikiPageProperties.save(fileOutputStream);
        fileOutputStream.close();
    }

    private Properties loadOldProperties(File file) throws IOException {
        Properties properties = new Properties();
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        return properties;
    }
}

