/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.updates.Update;
import fitnesse.updates.Updater;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class FileUpdate
implements Update {
    private static final String slash = "/";
    protected String destination;
    protected String source;
    protected File destinationDir;
    protected String rootDir;
    protected String filename;

    public FileUpdate(Updater updater, String string, String string2) throws Exception {
        this.destination = string2;
        this.source = string;
        this.rootDir = updater.context.rootPagePath;
        this.destinationDir = new File(new File(this.rootDir), string2);
        this.filename = new File(string).getName();
    }

    public void doUpdate() throws Exception {
        this.makeSureDirectoriesExist();
        this.copyResource();
    }

    private void makeSureDirectoriesExist() {
        String[] stringArray = this.destination.split(slash);
        String string = this.rootDir;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            string = string + slash + string2;
            File file = new File(string);
            file.mkdir();
        }
    }

    private void copyResource() throws Exception {
        FileOutputStream fileOutputStream;
        InputStream inputStream;
        URL uRL = this.getResource(this.source);
        if (uRL != null) {
            int n;
            inputStream = uRL.openStream();
            fileOutputStream = new FileOutputStream(this.destinationFile());
            while ((n = inputStream.read()) != -1) {
                ((OutputStream)fileOutputStream).write(n);
            }
        } else {
            throw new Exception("Could not load resource: " + this.source);
        }
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
    }

    protected URL getResource(String string) {
        return ClassLoader.getSystemResource(string);
    }

    public String getMessage() {
        return "Installing file: " + this.destinationFile();
    }

    protected File destinationFile() {
        return new File(this.destinationDir, this.filename);
    }

    public String getName() {
        return "FileUpdate(" + this.filename + ")";
    }

    public boolean shouldBeApplied() throws Exception {
        return !this.destinationFile().exists();
    }
}

