/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.updates.PageTraversingUpdate;
import fitnesse.updates.Updater;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;

public class AttributeAdderUpdate
extends PageTraversingUpdate {
    private String attributeName;

    public AttributeAdderUpdate(Updater updater, String string) {
        super(updater);
        this.attributeName = string;
    }

    public String getName() {
        return this.attributeName + "AttributeUpdate";
    }

    public String getMessage() {
        return "Adding '" + this.attributeName + "' attribute to all pages";
    }

    public void processPage(WikiPage wikiPage) throws Exception {
        try {
            PageData pageData = wikiPage.getData();
            pageData.setAttribute(this.attributeName, "true");
            wikiPage.commit(pageData);
        }
        catch (Exception exception) {
            String string = PathParser.render(wikiPage.getPageCrawler().getFullPath(wikiPage));
            System.out.println("Failed to add attribute " + this.attributeName + " to " + string);
            throw exception;
        }
    }

    public String getSearchPattern() {
        return ".*";
    }
}

