/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testutil;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;

public class MockSocket
extends Socket {
    InputStream input;
    OutputStream output;
    private String host;
    private boolean closed;

    public MockSocket() throws Exception {
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
        PipedInputStream pipedInputStream2 = new PipedInputStream();
        PipedOutputStream pipedOutputStream2 = new PipedOutputStream(pipedInputStream2);
        this.input = pipedInputStream;
        this.output = pipedOutputStream2;
    }

    public MockSocket(String string) {
        this.input = new ByteArrayInputStream(string.getBytes());
        this.output = new ByteArrayOutputStream();
    }

    public MockSocket(InputStream inputStream, OutputStream outputStream) {
        this.input = inputStream;
        this.output = outputStream;
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public void close() {
        this.closed = true;
        try {
            this.input.close();
            this.output.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getOutput() throws Exception {
        if (this.output instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.output).toString("UTF-8");
        }
        return "";
    }

    public void setHost(String string) {
        this.host = string;
    }

    public SocketAddress getRemoteSocketAddress() {
        return new InetSocketAddress(this.host, 123);
    }
}

