/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.socketservice;

import fitnesse.socketservice.SocketServer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;

public class SocketService {
    private ServerSocket serverSocket = null;
    private Thread serviceThread = null;
    private boolean running = false;
    private SocketServer server = null;
    private LinkedList threads = new LinkedList();

    public SocketService(int n, SocketServer socketServer) throws Exception {
        this.server = socketServer;
        this.serverSocket = new ServerSocket(n);
        this.serviceThread = new Thread(new Runnable(){

            public void run() {
                SocketService.this.serviceThread();
            }
        });
        this.serviceThread.start();
    }

    public void close() throws Exception {
        this.waitForServiceThreadToStart();
        this.running = false;
        this.serverSocket.close();
        this.serviceThread.join();
        this.waitForServerThreads();
    }

    private void waitForServiceThreadToStart() {
        while (!this.running) {
            Thread.yield();
        }
    }

    private void serviceThread() {
        this.running = true;
        while (this.running) {
            try {
                Socket socket = this.serverSocket.accept();
                this.startServerThread(socket);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServerThread(Socket socket) {
        Thread thread = new Thread(new ServerRunner(socket));
        LinkedList linkedList = this.threads;
        synchronized (linkedList) {
            this.threads.add(thread);
        }
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForServerThreads() throws InterruptedException {
        while (this.threads.size() > 0) {
            Thread thread;
            LinkedList linkedList = this.threads;
            synchronized (linkedList) {
                thread = (Thread)this.threads.getFirst();
            }
            thread.join();
        }
    }

    private class ServerRunner
    implements Runnable {
        private Socket socket;

        ServerRunner(Socket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                SocketService.this.server.serve(this.socket);
                LinkedList linkedList = SocketService.this.threads;
                synchronized (linkedList) {
                    SocketService.this.threads.remove(Thread.currentThread());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

