/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.schedule;

import fitnesse.schedule.Schedule;
import fitnesse.schedule.ScheduleItem;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ScheduleImpl
implements Schedule,
Runnable {
    private long delay;
    private Thread thread;
    private boolean running;
    private List scheduleItems = Collections.synchronizedList(new LinkedList());

    public ScheduleImpl(long l) {
        this.delay = l;
    }

    public void add(ScheduleItem scheduleItem) {
        this.scheduleItems.add(scheduleItem);
    }

    public void start() {
        this.running = true;
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.start();
    }

    public void stop() throws Exception {
        this.running = false;
        if (this.thread != null) {
            this.thread.join();
        }
        this.thread = null;
    }

    public void run() {
        try {
            while (this.running) {
                this.runScheduledItems();
                Thread.sleep(this.delay);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScheduledItems() throws Exception {
        long l = System.currentTimeMillis();
        List list = this.scheduleItems;
        synchronized (list) {
            for (ScheduleItem scheduleItem : this.scheduleItems) {
                this.runItem(scheduleItem, l);
            }
        }
    }

    private void runItem(ScheduleItem scheduleItem, long l) throws Exception {
        try {
            if (scheduleItem.shouldRun(l)) {
                scheduleItem.run(l);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

