/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fit.Counts;
import fitnesse.components.ContentBuffer;
import fitnesse.components.XmlWriter;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultFormatter;
import fitnesse.util.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlResultFormatter
implements ResultFormatter {
    private ContentBuffer buffer = new ContentBuffer(".xml");
    private Document document;
    private boolean closed = false;
    private byte[] tailBytes;

    public XmlResultFormatter(String string, String string2) throws Exception {
        this.createDocument(string, string2);
        this.writeDocumentHeader();
    }

    private void writeDocumentHeader() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlWriter xmlWriter = new XmlWriter(byteArrayOutputStream);
        xmlWriter.write(this.document);
        xmlWriter.close();
        String string = byteArrayOutputStream.toString();
        int n = string.indexOf("</testResults>");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        this.tailBytes = string3.getBytes();
        this.buffer.append(string2);
    }

    private void createDocument(String string, String string2) throws Exception {
        this.document = XmlUtil.newDocument();
        Element element = this.document.createElement("testResults");
        this.document.appendChild(element);
        XmlUtil.addTextNode(this.document, element, "host", string);
        XmlUtil.addTextNode(this.document, element, "rootPath", string2);
    }

    public void acceptResult(PageResult pageResult) throws Exception {
        Element element = this.document.createElement("result");
        XmlUtil.addTextNode(this.document, element, "relativePageName", pageResult.title());
        XmlUtil.addCdataNode(this.document, element, "content", pageResult.content());
        element.appendChild(this.makeCountsElement("counts", pageResult.counts()));
        this.writeElement(element);
    }

    public void acceptFinalCount(Counts counts) throws Exception {
        Element element = this.makeCountsElement("finalCounts", counts);
        this.writeElement(element);
    }

    public int getByteCount() throws Exception {
        this.close();
        return this.buffer.getSize();
    }

    public InputStream getResultStream() throws Exception {
        this.close();
        return this.buffer.getInputStream();
    }

    private void close() throws Exception {
        if (!this.closed) {
            this.buffer.append(this.tailBytes);
            this.closed = true;
        }
    }

    private void writeElement(Element element) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlWriter xmlWriter = new XmlWriter(byteArrayOutputStream);
        xmlWriter.write(element, 1);
        xmlWriter.close();
        this.buffer.append(byteArrayOutputStream.toByteArray());
    }

    private Element makeCountsElement(String string, Counts counts) {
        Element element = this.document.createElement(string);
        XmlUtil.addTextNode(this.document, element, "right", counts.right + "");
        XmlUtil.addTextNode(this.document, element, "wrong", counts.wrong + "");
        XmlUtil.addTextNode(this.document, element, "ignores", counts.ignores + "");
        XmlUtil.addTextNode(this.document, element, "exceptions", counts.exceptions + "");
        return element;
    }
}

