/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fit.Counts;
import fit.FitServer;
import fitnesse.components.CommandLine;
import fitnesse.runner.CachingResultFormatter;
import fitnesse.runner.FormattingOption;
import fitnesse.runner.PageResult;
import fitnesse.runner.StandardResultHandler;
import fitnesse.runner.TestRunnerFixtureListener;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;

public class TestRunner {
    private String host;
    private int port;
    private String pageName;
    private FitServer fitServer;
    public TestRunnerFixtureListener fixtureListener;
    public CachingResultFormatter handler;
    private PrintStream output;
    public List formatters = new LinkedList();
    private boolean debug;
    public boolean verbose;
    public boolean usingDownloadedPaths = true;

    public TestRunner() throws Exception {
        this(System.out);
    }

    public TestRunner(PrintStream printStream) throws Exception {
        this.output = printStream;
        this.handler = new CachingResultFormatter();
    }

    public static void main(String[] stringArray) throws Exception {
        TestRunner testRunner = new TestRunner();
        testRunner.run(stringArray);
        System.exit(testRunner.exitCode());
    }

    public void args(String[] stringArray) throws Exception {
        CommandLine commandLine = new CommandLine("[-debug] [-v] [-results file] [-html file] [-xml file] [-nopath] host port pageName");
        if (!commandLine.parse(stringArray)) {
            this.usage();
        }
        this.host = commandLine.getArgument("host");
        this.port = Integer.parseInt(commandLine.getArgument("port"));
        this.pageName = commandLine.getArgument("pageName");
        if (commandLine.hasOption("debug")) {
            this.debug = true;
        }
        if (commandLine.hasOption("v")) {
            this.verbose = true;
            this.handler.addHandler(new StandardResultHandler(this.output));
        }
        if (commandLine.hasOption("nopath")) {
            this.usingDownloadedPaths = false;
        }
        if (commandLine.hasOption("results")) {
            this.formatters.add(new FormattingOption("raw", commandLine.getOptionArgument("results", "file"), this.output, this.host, this.port, this.pageName));
        }
        if (commandLine.hasOption("html")) {
            this.formatters.add(new FormattingOption("html", commandLine.getOptionArgument("html", "file"), this.output, this.host, this.port, this.pageName));
        }
        if (commandLine.hasOption("xml")) {
            this.formatters.add(new FormattingOption("xml", commandLine.getOptionArgument("xml", "file"), this.output, this.host, this.port, this.pageName));
        }
    }

    private void usage() {
        System.out.println("usage: java fitnesse.runner.TestRunner [options] host port page-name");
        System.out.println("\t-v \tverbose: prints test progress to stdout");
        System.out.println("\t-results <filename|'stdout'>\tsave raw test results to a file or dump to standard output");
        System.out.println("\t-html <filename|'stdout'>\tformat results as HTML and save to a file or dump to standard output");
        System.out.println("\t-debug \tprints FitServer protocol actions to stdout");
        System.out.println("\t-nopath \tprevents downloaded path elements from being added to classpath");
        System.exit(-1);
    }

    public void run(String[] stringArray) throws Exception {
        this.args(stringArray);
        this.fitServer = new FitServer(this.host, this.port, this.debug);
        this.fixtureListener = new TestRunnerFixtureListener(this);
        this.fitServer.fixtureListener = this.fixtureListener;
        this.fitServer.establishConnection(this.makeHttpRequest());
        this.fitServer.validateConnection();
        if (this.usingDownloadedPaths) {
            this.processClasspathDocument();
        }
        this.fitServer.process();
        this.finalCount();
        this.fitServer.closeConnection();
        this.fitServer.exit();
        this.doFormatting();
        this.handler.cleanUp();
    }

    private void processClasspathDocument() throws Exception {
        String string = this.fitServer.readDocument();
        if (this.verbose) {
            this.output.println("Adding to classpath: " + string);
        }
        TestRunner.addItemsToClasspath(string);
    }

    private void finalCount() throws Exception {
        this.handler.acceptFinalCount(this.fitServer.getCounts());
    }

    public int exitCode() {
        return this.fitServer == null ? -1 : this.fitServer.exitCode();
    }

    public String makeHttpRequest() {
        String string = "GET /" + this.pageName + "?responder=fitClient";
        if (this.usingDownloadedPaths) {
            string = string + "&includePaths=yes";
        }
        return string + " HTTP/1.1\r\n\r\n";
    }

    public Counts getCounts() {
        return this.fitServer.getCounts();
    }

    public void acceptResults(PageResult pageResult) throws Exception {
        Counts counts = pageResult.counts();
        this.fitServer.writeCounts(counts);
        this.handler.acceptResult(pageResult);
    }

    public void doFormatting() throws Exception {
        for (FormattingOption formattingOption : this.formatters) {
            if (this.verbose) {
                this.output.println("Formatting as " + formattingOption.format + " to " + formattingOption.filename);
            }
            formattingOption.process(this.handler.getResultStream(), this.handler.getByteCount());
        }
    }

    public static void addItemsToClasspath(String string) throws Exception {
        String[] stringArray = string.split(System.getProperty("path.separator"));
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            TestRunner.addUrlToClasspath(new File(string2).toURL());
        }
    }

    public static void addUrlToClasspath(URL uRL) throws Exception {
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> clazz = URLClassLoader.class;
        Method method = clazz.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)uRLClassLoader, uRL);
    }
}

