/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.runner;

import fit.Counts;
import fitnesse.runner.PageResult;
import fitnesse.runner.ResultHandler;
import java.io.InputStream;
import java.io.PrintStream;

public class StandardResultHandler
implements ResultHandler {
    private PrintStream output;
    private Counts pageCounts = new Counts();

    public StandardResultHandler(PrintStream printStream) {
        this.output = printStream;
    }

    public void acceptResult(PageResult pageResult) throws Exception {
        Counts counts = pageResult.counts();
        this.pageCounts.tallyPageCounts(counts);
        for (int i = 0; i < counts.right; ++i) {
            this.output.print(".");
        }
        if (counts.wrong > 0 || counts.exceptions > 0) {
            this.output.println();
            if (counts.wrong > 0) {
                this.output.println(this.pageDescription(pageResult) + " has failures");
            }
            if (counts.exceptions > 0) {
                this.output.println(this.pageDescription(pageResult) + " has errors");
            }
        }
    }

    private String pageDescription(PageResult pageResult) {
        String string = pageResult.title();
        if ("".equals(string)) {
            string = "The test";
        }
        return string;
    }

    public void acceptFinalCount(Counts counts) throws Exception {
        this.output.println();
        this.output.println("Test Pages: " + this.pageCounts);
        this.output.println("Assertions: " + counts);
    }

    public int getByteCount() {
        return 0;
    }

    public InputStream getResultStream() throws Exception {
        return null;
    }
}

